from PyQt4.QtCore import *
from PyQt4.QtGui import *

from Ui_ThreeDViewPage import Ui_ThreeDViewPage
from ConfigurationPageBase import ConfigurationPageBase
import Configuration

# (FIX?) Doesn't check if the string in "Types3DInvisible" can be 
# transformed to the list of integer numbers 

class ThreeDViewPage(ConfigurationPageBase, Ui_ThreeDViewPage):
    """
    Class implementing the 3D View configuration page.
    """
    def __init__(self):
        """
        Constructor
        """
        QWidget.__init__(self)
        self.setupUi(self)
        self.setObjectName("ThreeDViewPage")
        
        self.view = {}
        self.view["Types3DInvisible"] = Configuration.getThreeDView("Types3DInvisible")
        self.setSettings()
        self.setConnects()

    def setSettings(self):
        self.typeListEdit.setText(self.view["Types3DInvisible"])

    def setConnects(self):
        self.connect(self.typeListEdit, SIGNAL("textChanged(QString)"), self.listChanged)
    
    def listChanged(self):
        self.view["Types3DInvisible"] = self.typeListEdit.text()
    
    def save(self):
        """
        Public slot to save the ThreeDViewPage configuration.
        """
        for key in self.view.keys():
            Configuration.setThreeDView(key, self.view[key])
        
def create(dlg):
    """
    Module function to create the configuration page.
    
    @param dlg reference to the configuration dialog
    """
    return ThreeDViewPage()
