from PySteppables import *
import CompuCell
import sys


class NeighborTrackerPrinterSteppable(SteppablePy):
    def __init__(self,_simulator,_frequency=100):
        SteppablePy.__init__(self,_frequency)
        self.simulator=_simulator
        self.nTrackerPlugin=CompuCell.getNeighborTrackerPlugin()

        self.inventory=self.simulator.getPotts().getCellInventory()
        self.cellList=CellList(self.inventory)
    def start(self):pass

    def step(self,mcs):
        self.cellList=CellList(self.inventory)
        for cell in self.cellList:
            cellNeighborList=CellNeighborListAuto(self.nTrackerPlugin,cell)
            print "*********NEIGHBORS OF CELL WITH ID ",cell.id," *****************"
            for neighborSurfaceData in cellNeighborList:
                if neighborSurfaceData.neighborAddress:
                    print "neighbor.id",neighborSurfaceData.neighborAddress.id," commonSurfaceArea=",neighborSurfaceData.commonSurfaceArea
                else:
                    print "Medium commonSurfaceArea=",neighborSurfaceData.commonSurfaceArea



