from PySteppables import *
import CompuCell
import sys


from PlayerPython import *
from math import *

class ExtraFieldVisualizationSteppable(SteppablePy):
    def __init__(self,_simulator,_frequency=10):
        SteppablePy.__init__(self,_frequency)
        self.simulator=_simulator
        self.cellFieldG=self.simulator.getPotts().getCellFieldG()
        self.dim=self.cellFieldG.getDim()

    def setScalarField(self,_field):
        self.scalarField=_field

    def start(self):pass

    def step(self,mcs):
        for x in xrange(self.dim.x):
            for y in xrange(self.dim.y):
                for z in xrange(self.dim.z):
                    pt=CompuCell.Point3D(x,y,z)
                    if (not mcs%20):
                        value=x*y
                        fillScalarValue(self.scalarField,x,y,z,value)
                    else:
                        value=sin(x*y)
                        fillScalarValue(self.scalarField,x,y,z,value)

class IdFieldVisualizationSteppable(SteppablePy):
    def __init__(self,_simulator,_frequency=10):
        SteppablePy.__init__(self,_frequency)
        self.simulator=_simulator
        self.inventory=self.simulator.getPotts().getCellInventory()
        self.cellList=CellList(self.inventory)

    def setScalarField(self,_field):
        self.scalarField=_field

    def start(self):pass

    def step(self,mcs):
        for cell in self.cellList:
            # print "filling ",cell.id
            fillScalarValueCellLevel(self.scalarField,cell,cell.id)

class VectorFieldVisualizationSteppable(SteppablePy):
    def __init__(self,_simulator,_frequency=10):
        SteppablePy.__init__(self,_frequency)
        self.simulator=_simulator
        self.cellFieldG=self.simulator.getPotts().getCellFieldG()
        self.dim=self.cellFieldG.getDim()        
        self.inventory=self.simulator.getPotts().getCellInventory()
        self.cellList=CellList(self.inventory)

    def setVectorField(self,_field):
        self.vectorField=_field

    def start(self):pass

    
    def step(self,mcs):
        maxLength=0
        clearVectorField(self.dim,self.vectorField)
        import math
        for x in xrange(0,self.dim.x,5):
            for y in xrange(0,self.dim.y,5):
                for z in xrange(self.dim.z):
                     
                    pt=CompuCell.Point3D(x,y,z)
                    # print "pt=",pt
                    insertVectorIntoVectorField(self.vectorField,pt.x, pt.y,pt.z, pt.x, pt.y, pt.z)
                    # length=math.sqrt(pt.x**2+pt.y**2+pt.z**2)
                    # if maxLength<length:
                        # maxLength=length
                    
        # print "maxLength=",maxLength

class VectorFieldCellLevelVisualizationSteppable(SteppablePy):
    def __init__(self,_simulator,_frequency=10):
        SteppablePy.__init__(self,_frequency)
        self.simulator=_simulator
        self.inventory=self.simulator.getPotts().getCellInventory()
        self.cellList=CellList(self.inventory)

    def setVectorField(self,_field):
        self.vectorField=_field

    def start(self):pass

    def step(self,mcs):
        for cell in self.cellList:
            if cell.type==1:
                insertVectorIntoVectorCellLevelField(self.vectorField,cell, cell.id, cell.id, 0.0)
            
        