

function usage
{
# Temporary function stub
   echo "USAGE: ./compucell3d.sh -i <xmlFile> -p <pythonScript> -s <ScreenshotDescriptionFile> -o <outputDirectory> [--noOutput] [--silent] [--console] "
   echo "--silent mode will use Player to save screenshots but will not display GUI. You must provide screenshot description file to run in silent mode "
   echo "--console mode will run basic CompuCell3D kernel but will only be able to take as an input xml file. No screenshots are stored."
   echo "--noOutput mode will run CompuCell3D simulation but will not store any output."
   echo "To use console mode effectively one would need to develop modules that would eiter save or display lattice snapshots. For that reason it is recommended that you use CompuCellPlayer as it gives you nice set of visualization tools"
}

xmlFile=""
pythonScript=""
silentMode=""
consoleMode=""
scrDsc=""
noXServerMode="false"
outDir=""
noOutputFlag=""

while [ "$1" != "" ]; do
   case $1 in
       -i | --xml= )           shift
                               xmlFile=$1
                               echo "Configuration file: $xmlFile"
                               ;;
       -p  | --pythonScript=)           shift
                               pythonScript=$1
                               echo "Python script: $pythonScript"
                               ;;
       -s | --screenshotDescription )           shift
                               scrDsc=$1
                               echo "ScreenshotDescription file $scrDsc"
                               ;;

       -o | --outputDirectory )           shift
                               outDir=$1
                               echo "Simulation output will be stored in  $outDir"
                               ;;


       --silent  )             silentMode="true"
                               echo "SilentMode= $silentMode"
                               ;;

       --noXServer  )          noXServerMode="true"
                               echo "noXServerMode= $noXServerMode"
                               ;;

       --noOutput  )          noOutputFlag="true"
                               echo "noOutputFlag= $noOutputFlag"
                               ;;


       --console  )            consoleMode="true"
                               echo "ConsoleMode= $consoleMode"
                               ;;

       
       -h | --help )           usage
                               exit
                              ;;
       * )                     usage
                               exit 1
   esac
   shift
done

current_directory=$(pwd)
if [ -f "${current_directory}/${xmlFile}" ]
then
   xmlFile=${current_directory}/${xmlFile}
   echo "XML FILE ${current_directory}/${xmlFile} exists"
else
   echo "XML FILE  ${current_directory}/${xmlFile} does not exists"
fi

if [ -f "${current_directory}/${pythonScript}" ]
then
   pythonScript=${current_directory}/${pythonScript}
   echo "Python Script ${current_directory}/${pythonScript} exists"
else
   echo "Python Script ${current_directory}/${pythonScript} does not exists"
fi

if [ -f "${current_directory}/${scrDsc}" ]
then
   scrDsc=${current_directory}/${scrDsc}
   echo "Screenshot Description File ${current_directory}/${scrDsc} exists"
else
   echo "Screenshot Description File ${current_directory}/${scrDsc} does not exists"
fi

export PREFIX_CC3D=/Users/mitja/prova/CC3D342build/build_dir_aka_cmake_install_dir
cd $PREFIX_CC3D
export DYLD_LIBRARY_PATH=:$DYLD_LIBRARY_PATH
export DYLD_LIBRARY_PATH=${PREFIX_CC3D}/lib/:$DYLD_LIBRARY_PATH

export COMPUCELL3D_PLUGIN_PATH=${PREFIX_CC3D}/lib/CompuCell3DPlugins
export COMPUCELL3D_STEPPABLE_PATH=${PREFIX_CC3D}/lib/CompuCell3DSteppables
export DYLD_LIBRARY_PATH=${PREFIX_CC3D}/lib/pythonOld:$DYLD_LIBRARY_PATH
export DYLD_LIBRARY_PATH=${COMPUCELL3D_PLUGIN_PATH}:$DYLD_LIBRARY_PATH
export DYLD_LIBRARY_PATH=${COMPUCELL3D_STEPPABLE_PATH}:$DYLD_LIBRARY_PATH
export DYLD_LIBRARY_PATH=:$DYLD_LIBRARY_PATH
export DYLD_LIBRARY_PATH=:$DYLD_LIBRARY_PATH
export SWIG_LIB_INSTALL_DIR=${PREFIX_CC3D}/lib/pythonOld
export PYTHON_MODULE_PATH=${PREFIX_CC3D}/pythonSetupScripts


export COMPUCELL3D_MAJOR_VERSION=3
export COMPUCELL3D_MINOR_VERSION=4
export COMPUCELL3D_BUILD_VERSION=2

export SOSLIB_PATH=${PREFIX_CC3D}/examplesSoslib

echo "CompuCell3D - version $COMPUCELL3D_MAJOR_VERSION.$COMPUCELL3D_MINOR_VERSION.$COMPUCELL3D_BUILD_VERSION"

#NOTE: when dealing with strings in shell and doing comparisons etc. you eed to quote string variables

################################## CONSOLE MODE
if [ "$consoleMode" = "true" ]
then
#    echo "inside console $xmlFile $pythonScript"
   if [ "$xmlFile" != "" -a  "$pythonScript" = "" ]
   then
      ${PREFIX_CC3D}/bin/CompuCell3D $xmlFile
      exit 0
   else
      echo "Please specify xml file but not python file. Currently you cannot run python files in the console mode. For usage type run_CompuCellNew.sh --help"
   fi
fi

################################## PLAYER SILENT MODE

if [ "$silentMode" = "true" ]
then
   if [ "$xmlFile"  !=  "" -a "$scrDsc" != "" ]
   then
      if [ "$noXServerMode" == "true" ]
      then
         if [ "$pythonScript" != "" ]
         then
            if [ "$noOutputFlag" == "true" ]
            then   
               ${PREFIX_CC3D}/bin/CompuCellPlayer --silent --noXServer --xml=$xmlFile --pythonScript=$pythonScript --screenshotDescription=$scrDsc --outputDirectory=$outDir --noOutput
            else
               ${PREFIX_CC3D}/bin/CompuCellPlayer --silent --noXServer --xml=$xmlFile --pythonScript=$pythonScript --screenshotDescription=$scrDsc --outputDirectory=$outDir 
            fi
         else
            if [ "$noOutputFlag" == "true" ]
            then
               ${PREFIX_CC3D}/bin/CompuCellPlayer --silent --noXServer --xml=$xmlFile --screenshotDescription=$scrDsc --outputDirectory=$outDir --noOutput
            else
               ${PREFIX_CC3D}/bin/CompuCellPlayer --silent --noXServer --xml=$xmlFile --screenshotDescription=$scrDsc --outputDirectory=$outDir 
            fi
         fi
      else
         if [ "$pythonScript" != "" ]
         then
            if [ "$noOutputFlag" == "true" ]
            then
               ${PREFIX_CC3D}/bin/CompuCellPlayer --silent --xml=$xmlFile --pythonScript=$pythonScript --screenshotDescription=$scrDsc --outputDirectory=$outDir --noOutput
            else
               ${PREFIX_CC3D}/bin/CompuCellPlayer --silent --xml=$xmlFile --pythonScript=$pythonScript --screenshotDescription=$scrDsc --outputDirectory=$outDir 
            fi
         else
            if [ "$noOutputFlag" == "true" ]
            then
               ${PREFIX_CC3D}/bin/CompuCellPlayer --silent --xml=$xmlFile --screenshotDescription=$scrDsc --outputDirectory=$outDir --noOutput
            else
               ${PREFIX_CC3D}/bin/CompuCellPlayer --silent --xml=$xmlFile --screenshotDescription=$scrDsc --outputDirectory=$outDir 
            fi

         fi
      fi
   exit 0
   elif [ "$pythonScript" != "" -a "$scrDsc" != "" ]
   then
      if [ "$noOutputFlag" == "true" ]
      then
         ${PREFIX_CC3D}/bin/CompuCellPlayer --silent  --pythonScript=$pythonScript --screenshotDescription=$scrDsc --outputDirectory=$outDir --noOutput
      else
         ${PREFIX_CC3D}/bin/CompuCellPlayer --silent  --pythonScript=$pythonScript --screenshotDescription=$scrDsc --outputDirectory=$outDir 
      fi
   exit 0
   else
      echo "Please specify xml config file (or Python script) and screenshot description file for the silent mode. For usage type run_CompuCellNew.sh --help"
      exit 0
   fi
fi


################################## PLAYER MODE WITH GUI 
if [ "$xmlFile"  !=  "" ]
then
   if [ "$consoleMode" != "true" -a "$silentMode" != "true" ]
   then
      if [ "$pythonScript" != "" ]
      then
         if [ "$noOutputFlag" == "true" ]
         then
            ${PREFIX_CC3D}/bin/CompuCellPlayer --xml=$xmlFile --pythonScript=$pythonScript --screenshotDescription=$scrDsc --outputDirectory=$outDir --noOutput
         else
            ${PREFIX_CC3D}/bin/CompuCellPlayer --xml=$xmlFile --pythonScript=$pythonScript  --screenshotDescription=$scrDsc --outputDirectory=$outDir
         fi
      else
         if [ "$noOutputFlag" == "true" ]
         then
            ${PREFIX_CC3D}/bin/CompuCellPlayer --xml=$xmlFile --outputDirectory=$outDir --screenshotDescription=$scrDsc --noOutput
         else
            ${PREFIX_CC3D}/bin/CompuCellPlayer --xml=$xmlFile --outputDirectory=$outDir --screenshotDescription=$scrDsc
         fi
      fi
   fi
elif [ "$pythonScript" != "" ] 
then
   if [ "$noOutputFlag" == "true" ]
   then
      ${PREFIX_CC3D}/bin/CompuCellPlayer  --pythonScript=$pythonScript --screenshotDescription=$scrDsc --outputDirectory=$outDir --noOutput
   else
      ${PREFIX_CC3D}/bin/CompuCellPlayer  --pythonScript=$pythonScript  --screenshotDescription=$scrDsc --outputDirectory=$outDir
   fi

else
   ################################## DEFAULT CASE IF NO ARGUMNTS ARE GIVEN 
   ${PREFIX_CC3D}/bin/CompuCellPlayer
fi






