from cc3d.core.PySteppables import *

class cell_sort_in_cupSteppable(SteppableBasePy):

    def __init__(self, frequency=10):
        SteppableBasePy.__init__(self, frequency)

    def start(self):
        # creates some graphs
        self.plot_win = self.add_new_plot_window(title='Heterologous surface by cell type',
                                                 x_axis_title='MonteCarlo Step (MCS)', x_scale_type='linear', 
                                                 y_axis_title='hetero Surface Area',   y_scale_type='linear',
                                                 grid=False)
        self.plot_win.add_plot("Cond", style='Lines', color='blue',  size=2)
        self.plot_win.add_plot("NonC", style='Lines', color='green', size=1)

        self.plot_win2 = self.add_new_plot_window(title='Cell 1 motility (pseudo Temperature)',
                                                 x_axis_title='MonteCarlo Step (MCS)', x_scale_type='linear', 
                                                 y_axis_title='Motility',   y_scale_type='linear',
                                                 grid=True)
        self.plot_win2.add_plot("Mot1", style='Lines', color='blue',  size=2)
        self.plot_win2.add_data_point("Mot1",    0, 10)      
        self.plot_win2.add_data_point("Mot1", 1000, 10)      
        
        # build the wall (the cup)
        print("\n\t\t",self.dim.x,self.dim.y)
        for x in range(0,self.dim.x,5):   # cells are 5 pixels across
            self.cell_field[x:x+5, 0:5, 0] = self.new_cell(self.WALL)
        for y in range(0,self.dim.y,5):   # cells are 5 pixels across
            self.cell_field[0:5, y:y+5, 0] = self.new_cell(self.WALL)
            self.cell_field[self.dim.x-5:self.dim.x, y:y+5, 0] = self.new_cell(self.WALL)

    def step(self, mcs) :
                
        # update the graph
        if mcs % 500 == 0:
            # sum up the non-homologous surface area for each cell type
            condHeteroSum = 0
            condHomoSum = 0
            for cell in self.cell_list_by_type(self.CONDENSING):
                # you can access/manipulate cell properties here
                for neighbor, common_surface_area in self.get_cell_neighbor_data_list(cell):
                    if neighbor:
                        if neighbor.type != cell.type:
                            #print("neighbor.id", neighbor.id, " commonSurfaceArea=", common_surface_area)
                            condHeteroSum +=  common_surface_area
                        else:  # the two cells are of the same type
                            condHomoSum += common_surface_area
                    else:
                        #print("      Medium commonSurfaceArea=", common_surface_area)
                        condHeteroSum +=  common_surface_area
            # arguments are (name of the data series, x, y)
            self.plot_win.add_data_point("Cond", mcs, condHeteroSum)            
            
            condHeteroSum = 0
            condHomoSum = 0
            for cell in self.cell_list_by_type(self.NONCONDENSING):
                # you can access/manipulate cell properties here
                for neighbor, common_surface_area in self.get_cell_neighbor_data_list(cell):
                    if neighbor:
                        if neighbor.type != cell.type:
                            #print("neighbor.id", neighbor.id, " commonSurfaceArea=", common_surface_area)
                            condHeteroSum +=  common_surface_area
                        else:  # the two cells are of the same type
                            condHomoSum += common_surface_area
                    else:
                        #print("      Medium commonSurfaceArea=", common_surface_area)
                        condHeteroSum +=  common_surface_area
            # arguments are (name of the data series, x, y)
            self.plot_win.add_data_point("NonC", mcs, condHeteroSum)            
            
        if mcs % 1000 == 0:  # simulated annealing, raise the "temperature" then lower it to zero
            if mcs >= 10000:
                if  mcs <= 40000:
                    deltaT = 2
                else:
                    deltaT = -2
                print("\n\t\t\tmcs,deltaT:",mcs,deltaT)
                for cell in self.cell_list_by_type(self.CONDENSING, self.NONCONDENSING):
                    cell.fluctAmpl += deltaT
                    if cell.fluctAmpl < 0:
                        cell.fluctAmpl = 0
                    if cell.id == 1:
                        self.plot_win2.add_data_point("Mot1", mcs, cell.fluctAmpl)            
            
    def finish(self):
        # Finish Function gets called after the last MCS
        pass
