from cc3d.core.PySteppables import *

class TrackCellCOMSteppable(SteppableBasePy):
    def __init__(self,frequency=1):
        SteppableBasePy.__init__(self,frequency)

    def start(self):     
        for cell in self.cell_list:
            cell.targetVolume =25
            cell.lambdaVolume = 3
            cell.targetSurface=20
            cell.lambdaSurface= 1
        
        # Approach 1: create a user controlled pixel-level field to hold the cell's old positions 
        self.create_scalar_field_py("cell_track")
        # Approach 2: make a plot of the cells positions
        self.plot_win = self.add_new_plot_window(title='Cell COM Track',
                                                 x_axis_title='X', x_scale_type='linear',
                                                 y_axis_title='Y', y_scale_type='linear',
                                                 grid=False)
        self.plot_win.add_plot("Track", style='dot', color='white', size=1)
        # make some dots to force the plot to autoscale like we want (0,0),(100,100)
        # arguments are (name of the data series, x, y)
        self.plot_win.add_data_point("Track",0,    0)
        self.plot_win.add_data_point("Track",0,  100)
        self.plot_win.add_data_point("Track",100,  0)
        self.plot_win.add_data_point("Track",100,100)
        
    def step(self,mcs):
        # just tracking the center of "acell" type every 100th MCS
        if mcs % 10 == 0:
            for cell in self.cell_list_by_type(self.ACELL):
                # this cell's center of mass (COM) is at (cell.xCOM,cell.yCOM,cell.zCOM)
                # Approach 1: using the field:
                field = self.field.cell_track
                field[int(cell.xCOM),int(cell.yCOM),int(cell.zCOM)] = mcs # just set the pixel to equal the number of mcs so far
                # Approach 2: using the plot:
                self.plot_win.add_data_point("Track",cell.xCOM,cell.yCOM)  # don't need int's
                