from cc3d.cpp.PlayerPython import * 
from cc3d import CompuCellSetup

from cc3d.core.PySteppables import *
from random import uniform
from random import *
import numpy as np

class Module4_2_1Steppable(SteppableBasePy):
    def __init__(self, frequency=1):
        SteppableBasePy.__init__(self,frequency)

    def start(self):
        # assign the constraints to the starting compartmental cell and add all the component cells to it
        cytoVol=400
        for cell in self.cell_list_by_type(self.CYTO):
            cell.targetVolume = cytoVol
            cell.lambdaVolume = 5
            cluster_id = cell.clusterId
        for cell in self.cell_list_by_type(self.LAMEL):
            cell.targetVolume = .3*cytoVol
            cell.lambdaVolume = 5
            self.reassign_cluster_id(cell, cluster_id)
        for cell in self.cell_list_by_type(self.NUCLEUS):
            cell.targetVolume = .2*cytoVol
            cell.lambdaVolume = 4
            self.reassign_cluster_id(cell, cluster_id)
            
    def step(self, mcs):
        # setting new direction of cell
        
        for cell in self.cell_list_by_type(self.LAMEL):
            # force component pointing along X axis
            cell.lambdaVecX = 30 * uniform(-1, 1)            
            # force component pointing along Y axis
            cell.lambdaVecY = 30 * uniform(-1, 1)
            #print("\t\t changed direction cell.id,mcs:",cell.id,mcs)
        print()
        
    def finish(self):
        """
        Called after the last MCS to wrap up the simulation
        """

    def on_stop(self):
        """
        Called if the simulation is stopped before the last MCS
        """

class DivideClusterCellSteppable(MitosisSteppableClustersBase):
    def __init__(self, frequency=1):
        MitosisSteppableClustersBase.__init__(self, frequency)

    def step(self, mcs):
        if len(self.clusterList) < 16:  # stop dividing once this many cells have been reached
            mitosis_cluster_id_list = []
            mitosis_cluster_id_list_to_delete = []
            for compartment_list in self.clusterList:
                for cell in CompartmentList(compartment_list):  # this fetches the cluster_id
                    cluster_id = cell.clusterId
                    # only compartment cells with three subcompartments can divide
                    if len(compartment_list) < 3:
                        print('\n\t deleteing compartment cell without enough compartments')
                        if cluster_id not in mitosis_cluster_id_list_to_delete:
                            mitosis_cluster_id_list_to_delete.append(cluster_id)
                        continue
                    break

                # condition under which cluster mitosis takes place
                if random() < 0.05:  # Average MCS between cell division is the frequency this steppble is called divided by this
                    # instead of doing mitosis right away we store ids for clusters which should be divide.
                    # This avoids modifying cluster list while we iterate through it
                    mitosis_cluster_id_list.append(cluster_id)

            for cluster_id in mitosis_cluster_id_list:
                # # other valid options - to change mitosis mode leave one of the below lines uncommented
                # self.divide_cluster_random_orientation(cluster_id)
                # self.divide_cluster_orientation_vector_based(cluster_id, 1, 0, 0)
                # self.divide_cluster_along_major_axis(cluster_id)
                self.divide_cluster_along_minor_axis(cluster_id)

            for cluster_id in mitosis_cluster_id_list_to_delete:
                cluster_cell_list = self.get_cluster_cells(cluster_id)
                for cell in cluster_cell_list:
                    print('\t\t cell.id=',cell.id)
                    cell.targetVolume = 0
                    cell.lambdaVolume = 100

    def update_attributes(self):
        # compartments in the parent and child clusters are
        # listed in the same order so attribute changes require simple iteration through compartment list
        compartment_list_parent = self.get_cluster_cells(self.parent_cell.clusterId)

        self.clone_parent_cluster_2_child_cluster()
        
        
class ExtraVectorVisualSteppable(SteppableBasePy):
    def __init__(self, frequency=1):
        SteppableBasePy.__init__(self, frequency)
        self.vectorField = self.create_vector_field_cell_level_py("VELOCITY")        

    def start(self):
        for cell in self.cell_list_by_type(self.NUCLEUS):
            cell.dict["NoldX"]=0.               # dict entry for old NUC x CM
            cell.dict["NoldY"]=0.               # dict entry for old NUC y CM

    def step(self, mcs):
    # updating Velocity field    
        timeinterval = 100
        field = self.vectorField                        # placeholder for the vector field
        if mcs%timeinterval == 0.:
            for cell in self.cell_list_by_type(self.NUCLEUS):
                delX=cell.xCOM-cell.dict["NoldX"]                      # NUC x displacement
                if   delX<-self.dim.x/2.: delX+=self.dim.x           # x periodic bounday correction
                elif delX> self.dim.x/2.: delX-=self.dim.x 
                NVelX=delX/timeinterval                                  # NUC x compon Vel
                #
                delY=cell.yCOM-cell.dict["NoldY"]                     # NUC y displacement
                if   delY<-self.dim.y/2.: delY+=self.dim.y          # y periodic bounday correction
                elif delY> self.dim.y/2.: delY-=self.dim.y 
                NVelY=delY/timeinterval                                 # NUC y compon Vel

                field[cell] = [NVelX, NVelY, 0.]                        # filling the field with values
                
               
                cell.dict["NoldX"]=cell.xCOM                           # storing actual NUC x CM
                cell.dict["NoldY"]=cell.yCOM                           # storing actual NUC x CM

    def finish(self):
        '''
        this function may be called at the end of simulation - used very infrequently though
        '''        
        # PLACE YOUR CODE BELOW THIS LINE
        
        return

    def on_stop(self):
        '''
        this gets called each time user stops simulation
        '''        
        # PLACE YOUR CODE BELOW THIS LINE
        
        return
