from cc3d.core.PySteppables import *

class DurotaxisSteppable(SteppableBasePy):

    def __init__(self,frequency=1):
        SteppableBasePy.__init__(self,frequency)

    def start(self):
        # assign target volumes etc to all the cells created by the UniformInitializer plugin       
        for cell in self.cell_list:
            cell.targetVolume = cell.volume
            cell.lambdaVolume = 1
            cell.targetSurface = cell.surface
            cell.lambdaSurface = 0.1
            
        # Create a user-managed cell level "field" to allow coloring by the adhesion molecule amount
        self.create_scalar_field_cell_level_py("Actin")
        # Create another user-managed pixel level "field" to track the location of the mobile cells
        self.create_scalar_field_py("CellTrack")
        
        ### NOTES: Assignments of adhesions molecules in start doesn't appear to propagate into step!
        # Assign vaiable adhesions to individual 1-pixel cells on the ECM layer
        # visit all cells in a 10-pixel wide stripe across the middle of the bottom layer
#        fieldActin = self.field.Actin  # just for display purposes
#        ActinHighValue = 10.0  # this is the value for the "sticky" areas
#        for ix in range(int(self.dim.x/2)-5,int(self.dim.x/2)+5):
#            for iy in range(0,self.dim.y):
#                cell = self.cell_field[ix,iy,0]  # get the cell at this pixel
#                print(ix,iy,cell.id,cell.type)
#                # Make sure AdhesionFlex plugin is loaded
#                # setting adhesion molecule density using its index
#                # molecules are indexed in the same order they are listed in the xml file
#              ###self.adhesionFlexPlugin.setAdhesionMoleculeDensityByIndex(cell,0,ActinHighValue)
#                print("\t\t\t\t\t",ActinHighValue)
#                self.adhesionFlexPlugin.setAdhesionMoleculeDensity(cell,"actin",ActinHighValue)
#                a=self.adhesionFlexPlugin.getAdhesionMoleculeDensity(cell,"actin")
#                print("\t\t\t\t\t",a)              
#                # and put the value in the display field (don't forget to update if actin values change)
#                fieldActin[cell] = ActinHighValue     
     
#        # one last check that a particular cell's actin is set
#        cell = self.cell_field[50,50,0]  # get the cell at this pixel
#        a=self.adhesionFlexPlugin.getAdhesionMoleculeDensity(cell,"actin")
#        print("\t\t\t\t\t","-0-",cell.id,cell.type," actin:",a)

    def step(self,mcs):
        ### since this doesn't work in start do it at mcs==1
        if mcs == 1:
            # Assign vaiable adhesions to individual 1-pixel cells on the ECM layer
            # visit all cells in a 20-pixel wide stripe across the middle of the bottom layer
            fieldActin = self.field.Actin  # just for display purposes
            ActinHighValue = 10.0  # this is the value for the "sticky" areas
            for ix in range(int(self.dim.x/2)-10,int(self.dim.x/2)+10):
                for iy in range(0,self.dim.y):
                    cell = self.cell_field[ix,iy,0]  # get the cell at this pixel
                    print(ix,iy,cell.id,cell.type)
                    # Make sure AdhesionFlex plugin is loaded
                    # setting adhesion molecule density using its index
                    # molecules are indexed in the same order they are listed in the xml file
                    self.adhesionFlexPlugin.setAdhesionMoleculeDensity(cell,"actin",ActinHighValue)
                    a=self.adhesionFlexPlugin.getAdhesionMoleculeDensity(cell,"actin")
                    print("\t\t\t\t\t",a)
                    # and put the value in the display field (don't forget to update if actin values change)
                    fieldActin[cell] = ActinHighValue     

        if mcs % 100 == 0:  # update every 100 mcs, track the location of the cells
            for cell in self.cell_list_by_type(self.MOBILECELL):
                fieldCellTrack = self.field.CellTrack  # just for display purposes
                fieldCellTrack[int(cell.xCOM), int(cell.yCOM), 5] = mcs  # note this is only on z=5

        