from cc3d.core.PySteppables import *

# Rasterize a line from (x1,y1,z1) to (x2,y2,z2), integers
# returns a list of lists of pixel cordinates, ((px1,py1,pz1),(px2,py2,pz2),(px3,py3,pz3),(px4,py4,pz4), ...),
# that lie along the line from (x1,y1,z1) to (x2,y2,z2).
def drawDDA(x1,y1,z1,x2,y2,z2):
    pixList=[]
    x = x1; y = y1; z = z1;
    length = max(abs(x2-x1),abs(y2-y1),abs(z2-z1))
    dx = (x2-x1)/float(length)
    dy = (y2-y1)/float(length)
    dz = (z2-z1)/float(length)
    pixList.append((int(x),int(y),int(z)))
    for i in range(abs(length)):
        x += dx
        y += dy
        z += dz
        pixList.append((int(x+0.5),int(y+0.5),int(z+0.5)))
    return pixList
        
class CC3D_fibersSteppable(SteppableBasePy):
    def __init__(self,frequency=1):
        SteppableBasePy.__init__(self,frequency)
    
    def start(self):
        import random
        import math        
        # parameters for generating the fibers
        v  = 4   # 20  number of fibers 
        fl = 70. # length of the fibers in pixels
                
        self.lastCellIDlist=[]  # keep track of the last cell on each fiber
        for i in range(v):  # loop over the number of fibers to create
            # generate the list of pixels along a randomly positioned line
            notValid=True
            while notValid:  # generate random lines until find one that isn't too close to the wall
                x1 = int(self.dim.x*random.random())
                y1 = int(self.dim.y*random.random())
                z1 = int(self.dim.z*random.random())
                theta = 2*math.pi*random.random()
                gamma = 2*math.pi*random.random()
                x2 = int(x1+fl*math.cos(theta))
                y2 = int(y1+fl*math.sin(theta))
                z2 = int(z1+fl*math.sin(gamma))  # not right for 3d
                if (x2>20 and x2<(self.dim.x-20)) and (x1>20 and x1<(self.dim.x-20)) and \
                   (y2>20 and y2<(self.dim.y-20)) and (y1>20 and y1<(self.dim.y-20)) and \
                   (z2>20 and z2<(self.dim.z-20)) and (z1>20 and z1<(self.dim.z-20)):
                    notValid = False
                    print("\t\tOK    i, x1,y1,z1  x2,y2,z2  :",i,"  ",x1,y1,z1,"  ",x2,y2,z2)

            pixList=[]
            pixList=drawDDA(x1,y1,z1, x2,y2,z2)

            # create cells along this line (the fiber is modeled as a set of linked cells)
            litIT=0
            cellCnt=0
            lastCell=False;  lastlastCell=False;
            # create the first cell for this fiber
            cell = self.new_cell(self.FIBERCELL)  #### create a new cell for this fiber
            cell.targetVolume = 175  
            cell.lambdaVolume = 20 
            cellCnt += 1
            for (px,py,pz) in pixList: 
                if (litIT > 1) and (litIT % 5 == 0):  # taking 5 pixels steps
                    if lastCell: lastlastCell = lastCell;
                    lastCell = cell;
                    cell = self.new_cell(self.FIBERCELL)  #### create a new cell for this fiber
                    cell.targetVolume = 175  
                    cell.lambdaVolume = 20 
                    cellCnt += 1
                    # link this cell to the previous one and two in the fiber
                    print("\t\t\t0: fiber i,litIT,cell.id:",i,litIT,cell.id,end="  ")
                    if lastCell: print(lastCell.id,end="  ")
                    if lastlastCell: print(lastlastCell.id,end="  ")
                    print()              
                    if cellCnt > 1:
                        self.focalPointPlasticityPlugin.createFocalPointPlasticityLink(cell,lastCell,20,5,100)
                        #print("\t\t\t1: fiber i,litIT,cell.id,lastCell.id:",i,litIT,cell.id,lastCell.id)
                    if cellCnt > 2:
                        self.focalPointPlasticityPlugin.createFocalPointPlasticityLink(cell,lastlastCell,50,10,100)
                        #print("\t\t\t2: fiber i,litIT,cell.id,lastlastCell.id:",i,litIT,cell.id,lastlastCell.id)                            
                    
                litIT+=1
                #print("\t\tadding pixel x,y:",px,py)
                self.cell_field[px:px+4, py:py+4, pz:pz+4] = cell #### add this pixel to the cell
            self.lastCellIDlist.append(cell.id)   
        print("\n\n\tlastCellIDlist:",self.lastCellIDlist)   

    def step(self,mcs):
#         if mcs == 20:
#             for cell in self.cell_list:
#                 print("cell.id=",cell.id," volume=",cell.volume)
        if mcs == 20:
            # apply force to the last "cell" in each fiber
            for id in self.lastCellIDlist:
                cell = self.fetch_cell_by_id(id)
                print("\t\tforce cell ID, type:",cell.id,cell.type)
                # Make sure ExternalPotential plugin is loaded
                cell.lambdaVecX = -10. # force component pointing along X axis - towards positive X's
                cell.lambdaVecY = 0.  # force component pointing along Y axis - towards negative Y's
                cell.lambdaVecZ = 0.  # force component pointing along Z axis
            
    def finish(self):
        pass
        