from cc3d.core.PySteppables import *

# Rasterize a line from (x1,y1) to (x2,y2), integers
# returns a list of lists of pixel cordinates, ((px1,py1),(px2,py2),(px3,py3),(px4,py4), ...),
# that lie along the line from (x1,y1) to (x2,y2).
# based on https://gist.github.com/0xKD/4433688 (Python 3.x)
def drawDDA(x1,y1,x2,y2):
    pixList=[]
    x,y = x1,y1
    length = (x2-x1) if abs(x2-x1) > abs(y2-y1) else (y2-y1)
    dx = (x2-x1)/float(length)
    dy = (y2-y1)/float(length)
    pixList.append((int(x),int(y)))
    for i in range(abs(length)):
        x += dx
        y += dy
        pixList.append((int(x),int(y)))
    return pixList
        
class CC3D_fibersSteppable(SteppableBasePy):
    def __init__(self,frequency=1):
        SteppableBasePy.__init__(self,frequency)
    
    def start(self):
        import random
        import math        
        # parameters for generating the fibers
        lx = self.dim.x # 100  window x width
        ly = self.dim.y # 100  window y width
        v = 100  # 400  number of fibers 
        fl = 30. # length of the fibers in pixels
                
        for i in range(v):
            cell = self.new_cell(self.FIBERCELL)  #### create a new cell for this fiber
            pixList=[]
            m = int(lx*random.random())
            n = int(ly*random.random())
            theta = 2*math.pi*random.random()
            x = int(m+fl*math.cos(theta))
            y = int(n+fl*math.sin(theta))
            print(i, x,m, y,n)
            pixList=drawDDA(x,y, m,n)
            if len(pixList) > 0:
                for (px,py) in pixList:
                    px=min(max(px,0),lx-1)  # 0 <= px <= lx-1
                    py=min(max(py,0),ly-1)  # 0 <= py <= ly-1
                    self.cell_field[px:px+1, py:py+1, 0] = cell #### add this pixel to the cell
            cell.targetVolume = cell.volume  # the .xml says this cell type is frozen, 
            cell.lambdaVolume = 10000        # so this doesn't matter

    def step(self,mcs):
        if mcs == 10:
            for cell in self.cell_list:
                print("cell.id=",cell.id," volume=",cell.volume)

    def finish(self):
        pass


        