''' 
A demo of importing an image (photo) into CC3D
j. Sluka August 2020
'''
from cc3d.core.PySteppables import *

class CC3D_import_imageSteppable_Simple(SteppableBasePy):
    def __init__(self,frequency=1):
        SteppableBasePy.__init__(self,frequency)
        self.create_scalar_field_py("BMP_image")
        
    # def start(self):
        # self.unkownPixelText = ""
    
    def start(self):
        #### This requires the Python Image library. For python 3.7 in CC3D
        #### In a command window, set default into the directory:
        ####     C:\CompuCell3D-py3-64bit\python36\Scripts
        #### Then install the impage library using PIP:
        ####     pip.exe install Image
        
        import sys
#       sys.path.append(r'C:\\CompuCell3D-py3-64bit\\python36\\Scripts')
        from PIL import Image
    
        #################### File name for the image ################################
        self.inPath="C:/Users/Jim Sluka/Desktop/Jims Compucell/CC3D_importing_images/CC3D_import_image/Simulation/"
        self.inImage="astra_n2.jpg"  # Dog image, 200 x 251 pixels
        #
        img = Image.open(self.inPath+self.inImage)  # open the image
        print(img)  # print summary statistics for the image, such as the diemnsions
        ### currently Player's resize lattice is not working, you'll need to edit the 
        ### model dimensions in the Potts section of the main python file.
        #self.resize_and_shift_lattice(new_size=(img.size[0],img.size[1],0), shift_vec=(0,0,0))
        ############################################################################
    
    
        print("\n\t\tInput Path:",self.inPath)            
        print("\t\tInput File:",self.inImage)            
        print("\t\t+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++")
        if (img.size[0]>self.dim.x) or (img.size[1]>self.dim.y):
            print("ERROR-- image size:",img.size," is greater then the CC3D model size:",self.dim.x,self.dim.y,"  ...aborting")
            self.stop_simulation()
        else:
            print("\t\t OK IMAGE-- image size:",img.size," CC3D model size should be:",self.dim.x,self.dim.y)
        print("\t\t+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n")                        
        #img.show()

        # CC3D draws with the origin (0,0) in upper left, invert the data so the image matches CC3D
        self.img=img.transpose(Image.FLIP_TOP_BOTTOM)
        
        # map the pixels in the image to a user field
        field = self.field.BMP_image
        color_count = {}  # dictionary to store counts of the colors
        # loop over all the pixels in the image and count how often the r,g,b occurs and put
        # a value into the CC3D field for display
        # for the display we'll just sum the r, g, and b values then normalize to the rang 0:1
        #We could loop over all pixels in the CC3D window with:
            # for x,y,z in self.every_pixel():
        # instead we will loop over all pixels in the image
        for x in range(img.size[0]):
            for y in range(img.size[1]):
                (r,g,b) = self.img.getpixel((x,y))  # the r,g,b (red, green, blue) values for this pixel in the image
                gr=(r+g+b)/(255.*3)  # just map the r+g+b into 0-1
                field[x,y,0] = gr  # put the value in the CC3D user field
                
                # count the colors, use buckets 16 units wide, otherwise there are 16 million possible colors
                r16=int(r/16);  g16=int(g/16);  b16=int(b/16)
                pc=str(r16)+" "+str(g16)+" "+str(b16)
                if (pc) not in color_count:
                    color_count[pc] = 1
                else:
                    color_count[pc] += 1
        
        # list how often each color in the image occurs
        ####sorted_d = dict(sorted(color_count.items(), key=operator.itemgetter(1),reverse=True))
#        for k,v in sorted(color_count.items(), key=lambda kv: kv[1], reverse=True):
#            kl=k.split()
#            r=int(kl[0])*16;  g=int(kl[1])*16;  b=int(kl[2])*16;  
#            print("\t\t(",r,",",g,",",b,"):",v)
            
