''' 
A demo of importing an image (photo) into CC3D
j. Sluka August 2020
'''
def configure_simulation():

    from cc3d.core.XMLUtils import ElementCC3D
    
    CompuCell3DElmnt=ElementCC3D("CompuCell3D",{"Revision":"20200731","Version":"4.2.3"})
    
    PottsElmnt=CompuCell3DElmnt.ElementCC3D("Potts")
    # Basic properties of CPM (GGH) algorithm
    PottsElmnt.ElementCC3D("Dimensions",{"x":200,"y":251,"z":"1"})   ### change to match your image dimensions
    PottsElmnt.ElementCC3D("Steps",{},"11")
    PottsElmnt.ElementCC3D("Temperature",{},"10.0")
    PottsElmnt.ElementCC3D("NeighborOrder",{},"1")
    
    PluginElmnt=CompuCell3DElmnt.ElementCC3D("Plugin",{"Name":"CellType"})
    # Listing all cell types in the simulation
    PluginElmnt.ElementCC3D("CellType",{"TypeId":"0","TypeName":"Medium"})

    CompuCellSetup.setSimulationXMLDescription(CompuCell3DElmnt)

from cc3d import CompuCellSetup

configure_simulation()            

from CC3D_import_image_Simple_Steppables import CC3D_import_imageSteppable_Simple
CompuCellSetup.register_steppable(steppable=CC3D_import_imageSteppable_Simple(frequency=1))

CompuCellSetup.run()
