#PARAMETERS:
cd=12          #Typical cell diameter
Lx=10*cd       #Size of lattice - x
Ly=10*cd       #Size of lattice - y
Lz=15*cd       #Size of lattice - z
Trelax=400     #Time for cells to relax boundaries

debugFreq=100

#POTTS PARAMETERS:
Temp=50               #Potts temperature
Time=1+20000             #Total number of MCS
NOrder=4              #NeighborOrder

#CONTACT PARAMETERS:
CNOrder=4             #Distance of interaction
CINOrder=4            #Internal Distance of interaction

#VOLUYME PARAMETERS
LamV=4                #Lambda Volume
targV=cd*cd*cd        #Target Volume

#SUBCELLULAR PARAMETERS:
percApical=0.14       # % of Apical surface
percBasal=0.20        # % of Basal surface   
percLateral=0.66      # % of LAteral surface
pASick=percApical
pLSick=percLateral
pBSick=1 - percApical - percLateral

#CONTACT INHIBITION:
gFactor=0.8          #Growth factor
hillCoef=20          #Hill coeficient
critAlpha=0.35        #Critical alpha
gFactorSick  =gFactor
hillCoefSick =hillCoef
critAlphaSick=critAlpha

#LUMEN GROWTH:
Kl=1               
ApArea=6.*cd*cd*.2  # ApArea=1/Kr

def configureSimulation(sim,Lx,Ly,Lz,Temp,Time,NOrder,CNOrder,CINOrder,debugFreq):
    import CompuCellSetup
    from XMLUtils import ElementCC3D

    CompuCell3DElement=ElementCC3D("CompuCell3D",{"Version":"3.7.3"})

    #POTTS CONDITIONS
    potts=CompuCell3DElement.ElementCC3D("Potts")
    potts.ElementCC3D("Dimensions",{"x":Lx,"y":Ly,"z":Lz})
    potts.ElementCC3D("Temperature",{},Temp)
    potts.ElementCC3D("Steps",{},Time)
    potts.ElementCC3D("NeighborOrder",{},NOrder)
    potts.ElementCC3D("DebugOutputFrequency",{},debugFreq)
    #Setting periodic boundary conditions to all directions
    potts.ElementCC3D("Boundary_x",{},"Periodic")
    potts.ElementCC3D("Boundary_y",{},"Periodic")
    potts.ElementCC3D("Boundary_z",{},"Periodic")
   

    #CELL TYPES -> Lumen, Cyto, Apical, Basal, Lateral1, Lumen and Lateral2
    cellType=CompuCell3DElement.ElementCC3D("Plugin",{"Name":"CellType"})
    cellType.ElementCC3D("CellType",{"TypeName":"Medium","TypeId":0})
    cellType.ElementCC3D("CellType",{"TypeName":"Cyto","TypeId":1})
    cellType.ElementCC3D("CellType",{"TypeName":"Apical","TypeId":2})
    cellType.ElementCC3D("CellType",{"TypeName":"Basal","TypeId":3})
    cellType.ElementCC3D("CellType",{"TypeName":"Lateral","TypeId":4})
    cellType.ElementCC3D("CellType",{"TypeName":"Lumen","TypeId":5})
    cellType.ElementCC3D("CellType",{"TypeName":"Lateral2","TypeId":6})
            
    #CELL COLORS
    cellColor=CompuCell3DElement.ElementCC3D("Plugin",{"Name":"PlayerSettings"})
    cellColor.ElementCC3D("Cell",{"Type":0,"Color":"#000000"}) # Black        -> Medium
    cellColor.ElementCC3D("Cell",{"Type":1,"Color":"#FFFF99"}) # Light yellow -> Cyto
    cellColor.ElementCC3D("Cell",{"Type":2,"Color":"#009900"}) # Dark Green   -> Apical
    cellColor.ElementCC3D("Cell",{"Type":3,"Color":"#990000"}) # Dark red     -> Basal
    cellColor.ElementCC3D("Cell",{"Type":4,"Color":"#FF0000"}) # Red          -> Lateral1
    cellColor.ElementCC3D("Cell",{"Type":5,"Color":"#00E6E6"}) # Light blue   -> Lumen
    cellColor.ElementCC3D("Cell",{"Type":6,"Color":"#0000FF"}) # Blue         -> Lateral2
    cellColor.ElementCC3D("TypesInvisibleIn3D",{"Types":"0,1,4,5"})   # Don't show Medium,Cyto, Lateral1 and Lumen
    cellColor.ElementCC3D("VisualControl",{"ScreenshotFrequency":250,"ScreenUpdateFrequency":10})

    
    #CONTACT ENERGIES
    contact=CompuCell3DElement.ElementCC3D("Plugin",{"Name":"Contact"})
    #Medium
    contact.ElementCC3D("Energy",{"Type1":"Medium","Type2":"Medium"},0)
    contact.ElementCC3D("Energy",{"Type1":"Medium","Type2":"Cyto"},60)
    contact.ElementCC3D("Energy",{"Type1":"Medium","Type2":"Apical"},60)
    contact.ElementCC3D("Energy",{"Type1":"Medium","Type2":"Basal"},3)
    contact.ElementCC3D("Energy",{"Type1":"Medium","Type2":"Lateral"},8)
    contact.ElementCC3D("Energy",{"Type1":"Medium","Type2":"Lateral2"},8)    
    
    #Cyto
    contact.ElementCC3D("Energy",{"Type1":"Cyto","Type2":"Cyto"},60)
    contact.ElementCC3D("Energy",{"Type1":"Cyto","Type2":"Apical"},60)
    contact.ElementCC3D("Energy",{"Type1":"Cyto","Type2":"Basal"},60)
    contact.ElementCC3D("Energy",{"Type1":"Cyto","Type2":"Lateral"},60)
    contact.ElementCC3D("Energy",{"Type1":"Cyto","Type2":"Lateral2"},60)
    #Apical
    contact.ElementCC3D("Energy",{"Type1":"Apical","Type2":"Apical"},15)
    contact.ElementCC3D("Energy",{"Type1":"Apical","Type2":"Basal"},20)
    contact.ElementCC3D("Energy",{"Type1":"Apical","Type2":"Lateral"},20)
    contact.ElementCC3D("Energy",{"Type1":"Apical","Type2":"Lateral2"},20)
    #Basal
    contact.ElementCC3D("Energy",{"Type1":"Basal","Type2":"Basal"},20)
    contact.ElementCC3D("Energy",{"Type1":"Basal","Type2":"Lateral"},20)
    contact.ElementCC3D("Energy",{"Type1":"Basal","Type2":"Lateral2"},20)
    #Lateral(2)
    contact.ElementCC3D("Energy",{"Type1":"Lateral","Type2":"Lateral"},4)
    contact.ElementCC3D("Energy",{"Type1":"Lateral2","Type2":"Lateral2"},4)
    contact.ElementCC3D("Energy",{"Type1":"Lateral2","Type2":"Lateral"},4)
    #Lumen
    contact.ElementCC3D("Energy",{"Type1":"Lumen","Type2":"Lumen"},0)
    contact.ElementCC3D("Energy",{"Type1":"Lumen","Type2":"Medium"},60)
    contact.ElementCC3D("Energy",{"Type1":"Lumen","Type2":"Cyto"},60)
    contact.ElementCC3D("Energy",{"Type1":"Lumen","Type2":"Apical"},15)
    contact.ElementCC3D("Energy",{"Type1":"Lumen","Type2":"Basal"},20)
    contact.ElementCC3D("Energy",{"Type1":"Lumen","Type2":"Lateral"},20)
    contact.ElementCC3D("Energy",{"Type1":"Lumen","Type2":"Lateral2"},20)
    #Neighbor order
    contact.ElementCC3D("NeighborOrder",{},CNOrder)
    
    #INTERNAL CONTACT ENERGIES:
    cInternal=CompuCell3DElement.ElementCC3D("Plugin",{"Name":"ContactInternal"})
    #Cyto
    cInternal.ElementCC3D("Energy",{"Type1":"Cyto","Type2":"Apical"},0)
    cInternal.ElementCC3D("Energy",{"Type1":"Cyto","Type2":"Basal"},0)
    cInternal.ElementCC3D("Energy",{"Type1":"Cyto","Type2":"Lateral"},0)
    cInternal.ElementCC3D("Energy",{"Type1":"Cyto","Type2":"Lateral2"},0)
    #Apical
    cInternal.ElementCC3D("Energy",{"Type1":"Apical","Type2":"Basal"},2)
    cInternal.ElementCC3D("Energy",{"Type1":"Apical","Type2":"Lateral"},0)
    cInternal.ElementCC3D("Energy",{"Type1":"Apical","Type2":"Lateral2"},0)
    #Basal
    cInternal.ElementCC3D("Energy",{"Type1":"Basal","Type2":"Lateral"},0)
    cInternal.ElementCC3D("Energy",{"Type1":"Basal","Type2":"Lateral2"},0)
    #Lateral(2)
    cInternal.ElementCC3D("Energy",{"Type1":"Lateral","Type2":"Lateral"},0)
    cInternal.ElementCC3D("Energy",{"Type1":"Lateral2","Type2":"Lateral2"},0)
    #Neighbor order
    cInternal.ElementCC3D("NeighborOrder",{},CINOrder)
    
    #OTHER PLUGINS
    pTracker=CompuCell3DElement.ElementCC3D("Plugin",{"Name":"PixelTracker"})
    boundaryPTracker=CompuCell3DElement.ElementCC3D("Plugin",{"Name":"BoundaryPixelTracker"})
    vlFlex=CompuCell3DElement.ElementCC3D("Plugin",{"Name":"VolumeLocalFlex"})
    coMass=CompuCell3DElement.ElementCC3D("Plugin",{"Name":"CenterOfMass"})
    neighborTracker=CompuCell3DElement.ElementCC3D("Plugin",{"Name":"NeighborTracker"})    

    CompuCellSetup.setSimulationXMLDescription(CompuCell3DElement)

import CompuCellSetup
import CompuCell

sim,simThread = CompuCellSetup.getCoreSimulationObjects()
configureSimulation(sim,Lx,Ly,Lz,Temp,Time,NOrder,CNOrder,CINOrder,debugFreq)

# Create extra player fields here or add attibutes
pyAttributeAdder,dictAdder = CompuCellSetup.attachDictionaryToCells(sim)
CompuCellSetup.initializeSimulationObjects(sim,simThread)

# Add Python steppables here
steppableRegistry = CompuCellSetup.getSteppableRegistry()

from PKDSteppables import *
initCond=InitialConditions(sim,Trelax,cd,targV,LamV,percApical,percBasal,percLateral,pASick,pBSick,pLSick,Trelax)
steppableRegistry.registerSteppable(initCond)

cInhibition=ContactInhibition(sim,1,gFactor,hillCoef,critAlpha,gFactorSick,hillCoefSick,critAlphaSick,
                              percApical,percBasal,percLateral,pASick,pBSick,pLSick)
steppableRegistry.registerSteppable(cInhibition)

mitosis=Mitosis(sim,1,targV,LamV,percApical,percBasal,percLateral,pASick,pBSick,pLSick)
steppableRegistry.registerSteppable(mitosis)

lFlux=LumenFlux(sim,1,LamV,Kl,ApArea)
steppableRegistry.registerSteppable(lFlux)

# Create extra fields here or add attributes
dim=sim.getPotts().getCellFieldG().getDim()

CompuCellSetup.mainLoop(sim,simThread,steppableRegistry)


