#include "environment.cpp"

using namespace std;

#define   MEDIUM 0
#define     CYTO 1
#define   APICAL 2
#define    BASAL 3
#define  LATERAL 4
#define    LUMEN 5
#define LATERAL2 6
#define radDistance(um,dois) (sqrt(((dois).x-(um).x)*((dois).x-(um).x)+((dois).y-(um).y)*((dois).y-(um).y)))

Cell getCLumen(vector<Cell> lumenCells)
{
  Cell cell;
  for(Cell lum : lumenCells) if(fabs(lum.COM.x-40.) < 3. and fabs(lum.COM.y-40.) < 3.) { cell=lum; break; }
  return cell;
}

typedef struct { float meanHealthy,tubRadius,NCad8,meanSick,cystHeight,cystNeck; } toCalc;

void CalcFromVtk(string fileName,toCalc *out)
{
  uint k,l,m,count;
  CC3DEnvironment cc3d(fileName);
  /* Getting central lumen */
  vector<Cell> lumenCells=cc3d.cellListByType(LUMEN);
  Cell cLumen=getCLumen(lumenCells);
  
  /* Calculating healthy cells mean size and tubule radius */
  float vol=0.,radius=0.;
  vector<Cell> cluster,healthyCells=cc3d.cellListByType(LATERAL);
  for(Cell healthy : healthyCells)
    {
      cluster=cc3d.getClusterCells(healthy.clusterId);
      for( Cell clus : cluster)
	{
	  vol+=clus.volume;
	  if(clus.type == BASAL)
	    radius+=radDistance(clus.COM,cLumen.COM);
	}
    }
  out->meanHealthy=pow(float(vol)/float(healthyCells.size()),1./3.);
  float tubRadius=radius/float(healthyCells.size());
  out->tubRadius=tubRadius;
  
  /* Getting total number of sick cells  and cyst's height and mean size */
  float height=0; vol=0.; count=0;
  vector<Cell>  sickCells=cc3d.cellListByType(LATERAL2);
  for(Cell sick : sickCells)
    {
      cluster=cc3d.getClusterCells(sick.clusterId);
      for(Cell clus : cluster)
	{
	  vol+=clus.volume;
	  radius=radDistance(clus.COM,cLumen.COM);
	  if(radius > tubRadius) { height+=radius; count++; }
	} 
    }
  
  for(Cell lum : lumenCells)
    {
      if(lum.id != cLumen.id)
	{
	  vol+=lum.volume;
	  radius=radDistance(lum.COM,cLumen.COM);
	  if(radius > tubRadius) { height+=radius; count++; }
	}
    }
  out->NCad8=float(sickCells.size());
  out->meanSick=pow(float(vol)/float(sickCells.size()+lumenCells.size()-1),1./3.);
  ( count > 0 ? out->cystHeight=height/float(count) : out->cystHeight=0. );
  

  /* Calculating cyst's nech */
  uint minX,maxX,minY,maxY,minZ,maxZ;
  minX=minY=120; minZ=180; maxX=maxY=maxZ=0;   // Following dimensions from the lattice
  for(Cell sick : sickCells)
    {
      cluster=cc3d.getClusterCells(sick.clusterId);
      for(Cell clu: cluster)
	{
	  for(m=0;m<clu.volume;m++)
	    {
	      radius=radDistance(clu.pixel[m],cLumen.COM);
	      if((radius > (tubRadius + 0.)) and (radius < (tubRadius + 1.)))
		{
		  if(clu.pixel[m].x < minX) minX=clu.pixel[m].x;
		  if(clu.pixel[m].x > maxX) maxX=clu.pixel[m].x;

		  if(clu.pixel[m].y < minY) minY=clu.pixel[m].y;
		  if(clu.pixel[m].y > maxY) maxY=clu.pixel[m].y;

		  if(clu.pixel[m].z < minZ) minZ=clu.pixel[m].z;
		  if(clu.pixel[m].z > maxZ) maxZ=clu.pixel[m].z;
		}
	    }
	}
    }
  out->cystNeck=.5*(sqrt((maxX-minX)*(maxX-minX)+(maxY-minY)*(maxY-minY))+(maxZ-minZ));
  
  cc3d.Delete();
}

int main(void)
{
  uint dt=500,
    tot=285000/dt;
  toCalc *vec=new toCalc[tot];
 
  omp_set_num_threads(15);
#pragma omp parallel default(none) shared(tot,dt,vec)
  {
    string aux,str="../LatticeData/Step_000000.vtk";
    toCalc uno;
    uint pos=str.size()-4,
      id=omp_get_thread_num(),
      numThreads=omp_get_num_threads();
    
    for(uint k=id;k<tot;k+=numThreads)
      {
	aux=to_string((k+1)*dt); str.replace(pos-aux.size(),aux.size(),aux);
	CalcFromVtk(str,&uno);
	
#pragma omp critical
	vec[k]=uno;
      }
  }

  ofstream data;
  data.open("../DataMeasured.txt");
  for(uint k=0;k<tot;k++)
    {
  data << (k+1)*dt-400 << "\t" << vec[k].meanHealthy << "\t" << vec[k].tubRadius << "\t" << vec[k].NCad8 << "\t" \
       << vec[k].meanSick << "\t" << vec[k].cystHeight << "\t" << vec[k].cystNeck << endl;
}

  data.close();
  
  delete(vec);
  return 0;
}
