#include <iostream>
#include <string>
#include <map>
#include <vector>
#include <algorithm>
#include <cmath>
#include <fstream>
#include <omp.h>
#include <vtkStructuredPointsReader.h>
#include <vtkStructuredPoints.h>
#include <vtkPointData.h>
#include <vtkDataArray.h>
#include <vtkFloatArray.h>

#define uint(a) ((uint) floor(a))

typedef struct { uint x,y,z; } Pixel;
typedef struct {
  uint id,type,clusterId,volume;
  Pixel COM,*pixel;
  void New(int *dim)  { uint tot=uint(dim[0]*dim[1]*dim[2]/3.); pixel=new Pixel[tot]; }
  void Delete(void)   { delete(pixel); }
} Cell;
typedef struct {
  uint size,*list;
  void New(uint dim) { list=new uint[dim]; }
  void Delete(void)  { delete(list); }
} UList;


UList GetUnique(int *dim,uint *array)
{
  uint k,l,m,n,size,aux,
    max=uint(dim[0]*dim[1]*dim[2]),
    tot=uint(max/1728.);

  int *vec=new int[max];  for(k=0;k<max;k++) vec[k]=-1;
  
  size=1;
  for(k=0;k<dim[0];k++)
    for(l=0;l<dim[1];l++)
      for(m=0;m<dim[2];m++)
	{
	  aux=array[(k*dim[1]+l)*dim[2]+m];
	  for(n=0;n<size;n++) if(vec[n] == aux) break;
	  if(n == size) { vec[n-1]=aux; size++; }
	}
  size--;
  
  UList uni;
  uni.size=size;
  uni.list=new uint[size];
  for(k=0;k<size;k++) {
    uni.list[k]=vec[k];
  }
  
  free(vec);
  return uni;
}
#define DeleteUList(data) do { delete(data.list); } while(0)


