#include "header.cpp"

class CC3DEnvironment
{
private:
  uint NumOfCells,NumOfClusters,NumOfTypes;
  UList *listByType,*listByCluster;
  Cell *cell;

public:
  std::vector<Cell> cellList(void);
  std::vector<Cell> cellListByType(uint type);
  std::vector<Cell> getClusterCells(uint clusterId);
  void Delete(void);
  
  void SetCC3DEnvironment(std::string fileName);
  CC3DEnvironment(std::string fileName);
};

CC3DEnvironment::CC3DEnvironment(std::string fileName) { SetCC3DEnvironment(fileName); }
std::vector<Cell> CC3DEnvironment::cellList(void)
{
  std::vector<Cell> v; for(uint k=0;k<NumOfCells;k++)  v.push_back(cell[k]);
  return v;
}

std::vector<Cell> CC3DEnvironment::cellListByType(uint type)
{
  std::vector<Cell> v;
  if(type < NumOfTypes)
    {
      for(uint k=0;k<listByType[type].size;k++)  v.push_back(cell[listByType[type].list[k]]);
    }
  
    return v;
}

std::vector<Cell> CC3DEnvironment::getClusterCells(uint clusterId)
{
  std::vector<Cell> v; for(uint k=0;k<listByCluster[clusterId].size;k++) v.push_back(cell[listByCluster[clusterId].list[k]]);
  return v;
}

void CC3DEnvironment::Delete(void)
{
  uint k;
  for(k=0;k<NumOfCells;k++)     cell[k].Delete();           delete(cell);
  for(k=0;k<NumOfTypes;k++)    listByType[k].Delete();     delete(listByType);
  for(k=0;k<NumOfClusters;k++)  listByCluster[k].Delete();  delete(listByCluster);
}

void CC3DEnvironment::SetCC3DEnvironment(std::string fileName)
{
  vtkStructuredPointsReader *reader=vtkStructuredPointsReader::New();
  reader->SetFileName(fileName.c_str());
  reader->ReadAllVectorsOn();
  reader->ReadAllScalarsOn();
  reader->Update();

  vtkStructuredPoints *data=reader->GetOutput();
  int *dim=data->GetDimensions();
  
  uint k,l,m,n,o,
    *cellId=new uint[dim[0]*dim[1]*dim[2]],
    *cellType=new uint[dim[0]*dim[1]*dim[2]],
    *clusterId=new uint[dim[0]*dim[1]*dim[2]],
    *Transpose=new uint[dim[0]*dim[1]*dim[2]];
  double aux;


  /*  Getting cellId coordinates in the lattice */
  vtkDataArray *Lattice=data->GetPointData()->GetArray("CellId");
  for(k=0;k<dim[0]*dim[1]*dim[2];k++)
    { Lattice->GetTuple(k,&aux); Transpose[k]=uint(aux); }
  
  for(k=0;k<dim[0];k++)
    for(l=0;l<dim[1];l++)
      for(m=0;m<dim[2];m++)
	cellId[(k*dim[1]+l)*dim[2]+m]=Transpose[(m*dim[1]+l)*dim[0]+k];
  
  UList cellUnique=GetUnique(dim,cellId);  NumOfCells=cellUnique.size-1;  //Medium doesn't matter
  
  /* Getting cellType coordinates in the lattice */
  Lattice=data->GetPointData()->GetArray("CellType");
  for(k=0;k<dim[0]*dim[1]*dim[2];k++)
    { Lattice->GetTuple(k,&aux); Transpose[k]=uint(aux);}
  
  for(k=0;k<dim[0];k++)
    for(l=0;l<dim[1];l++)
      for(m=0;m<dim[2];m++)
	cellType[(k*dim[1]+l)*dim[2]+m]=Transpose[(m*dim[1]+l)*dim[0]+k];
  
  UList typeUnique=GetUnique(dim,cellType);  NumOfTypes=typeUnique.size;
  
  /* Getting clusterId coordinates in the lattice */
  Lattice=data->GetPointData()->GetArray("ClusterId");
  for(k=0;k<dim[0]*dim[1]*dim[2];k++)
    { Lattice->GetTuple(k,&aux); Transpose[k]=aux; }

  for(k=0;k<dim[0];k++)
    for(l=0;l<dim[1];l++)
      for(m=0;m<dim[2];m++)
	clusterId[(k*dim[1]+l)*dim[2]+m]=Transpose[(m*dim[1]+l)*dim[0]+k];

  UList clusterUnique=GetUnique(dim,clusterId);  NumOfClusters=clusterUnique.size-1; //Medium cluster doesn't matter
  std::map<uint,uint> cex;
  for(k=0;k<NumOfClusters;k++) cex[clusterUnique.list[k+1]]=k;
  
  std::map<uint,uint> iex;
  cell=new Cell[NumOfCells];  
  for(k=0;k<NumOfCells;k++)
    { cell[k].New(dim); cell[k].id=k; iex[cellUnique.list[k+1]]=k; cell[k].volume=0; }

  listByType=new UList[NumOfTypes];
  for(k=0;k<NumOfTypes;k++) {listByType[k].New(NumOfCells); listByType[k].size=0; }

  listByCluster=new UList[NumOfClusters];
  for(k=0;k<NumOfClusters;k++) { listByCluster[k].New(NumOfCells);  listByCluster[k].size=0; }
    
  for(k=0;k<dim[0];k++)
    for(l=0;l<dim[1];l++)
      for(m=0;m<dim[2];m++)
	if(cellType[(k*dim[1]+l)*dim[2]+m] != 0 )
	  {
	    n=iex[cellId[(k*dim[1]+l)*dim[2]+m]];
	    o=cell[n].volume; cell[n].volume++;
	    cell[n].pixel[o].x=k; cell[n].pixel[o].y=l; cell[n].pixel[o].z=m;
	  }
  
  
  Pixel sum; 
  for(k=0;k<NumOfCells;k++)
    {
      /* Setting type of each cell */
      l=cell[k].pixel[0].x;  m=cell[k].pixel[0].y;   n=cell[k].pixel[0].z;
      cell[k].type=cellType[(l*dim[1]+m)*dim[2]+n];

    
      /* Setting clusterId of each cell*/
      cell[k].clusterId=cex[clusterId[(l*dim[1]+m)*dim[2]+n]];
    
      /* Creating a list with all cells with certain type  and cluster */
      l=cell[k].type;       n=listByType[l].size;     listByType[l].size++;       listByType[l].list[n]=k;
      l=cell[k].clusterId;  n=listByCluster[l].size;  listByCluster[l].size++;    listByCluster[l].list[n]=k;
      
      /* Calculating center of mass of each cell */
      l=cell[k].volume;
      sum.x=0; sum.y=0; sum.z=0;
      for(m=0;m<l;m++)
	{
	  sum.x+=cell[k].pixel[m].x;
	  sum.y+=cell[k].pixel[m].y;
	  sum.z+=cell[k].pixel[m].z;
	}
	  
      cell[k].COM.x=uint(float(sum.x)/float(l));
      cell[k].COM.y=uint(float(sum.y)/float(l));
      cell[k].COM.z=uint(float(sum.z)/float(l));
    }

  reader->Delete();
  delete(Transpose);   delete(cellId);
  delete(cellType);    delete(clusterId);

  DeleteUList(cellUnique);
  DeleteUList(typeUnique);
  DeleteUList(clusterUnique);
}
  

