#PARAMETERS:
cd=12         #Typical cell diameter
Lx=10*cd       #Size of lattice - x
Ly=10*cd       #Size of lattice - y
Lz=10*cd       #Size of lattice - z

debugFreq=100  

#POTTS PARAMETERS:
Temp=50               #Potts temperature
Time=1+100000        #Total number of MCS
NOrder=4              #NeighborOrder

#CONTACT PARAMETERS:
CNOrder=4             #Distance of interaction
CINOrder=4            #Internal Distance of interaction

#VOLUYME PARAMETERS
LamV=16                #Lambda Volume


#SUBCELLULAR PARAMETERS:
percApical=0.084       # % of Apical
percBasal=0.120        # % of Basal 
percLateral=0.396      # % of Lateral
percCyto=1.-percLateral-percBasal-percApical;

#CONTACT INHIBITION:
gFactor=0.8          #Growth factor   
hillCoef=20          #Hill coeficient
critAlpha=0.18       #Critical alpha

#LUMEN GROWTH:
Kl=1                
ApArea=6.*cd*cd*.2  # ApArea=1/Kr

#CAD8-CAD8 ENERGY
Jll=4

def configureSimulation(sim,Lx,Ly,Lz,Temp,Time,NOrder,CNOrder,CINOrder,debugFreq,Jll):
    import CompuCellSetup
    from XMLUtils import ElementCC3D

    CompuCell3DElement=ElementCC3D("CompuCell3D",{"Version":"3.7.3"})

    #POTTS CONDITIONS
    potts=CompuCell3DElement.ElementCC3D("Potts")
    potts.ElementCC3D("Dimensions",{"x":Lx,"y":Ly,"z":Lz})
    potts.ElementCC3D("Temperature",{},Temp)
    potts.ElementCC3D("Steps",{},Time)
    potts.ElementCC3D("NeighborOrder",{},NOrder)
    potts.ElementCC3D("DebugOutputFrequency",{},debugFreq)
    #Setting periodic boundary conditions to all directions
    potts.ElementCC3D("Boundary_x",{},"Periodic")
    potts.ElementCC3D("Boundary_y",{},"Periodic")
    potts.ElementCC3D("Boundary_z",{},"Periodic")
    
    #CELL TYPES -> Lumen, Cyto, Apical, Basal,Cadherin8 and Lumen
    cellType=CompuCell3DElement.ElementCC3D("Plugin",{"Name":"CellType"})
    cellType.ElementCC3D("CellType",{"TypeName":"Medium","TypeId":0})
    cellType.ElementCC3D("CellType",{"TypeName":"Cyto","TypeId":1})
    cellType.ElementCC3D("CellType",{"TypeName":"Apical","TypeId":2})
    cellType.ElementCC3D("CellType",{"TypeName":"Basal","TypeId":3})
    cellType.ElementCC3D("CellType",{"TypeName":"Cadherin8","TypeId":4})
    cellType.ElementCC3D("CellType",{"TypeName":"Lumen","TypeId":5})
            
    #CELL COLORS
    cellColor=CompuCell3DElement.ElementCC3D("Plugin",{"Name":"PlayerSettings"})
    cellColor.ElementCC3D("Cell",{"Type":0,"Color":"#000000"}) # Black        -> Medium
    cellColor.ElementCC3D("Cell",{"Type":1,"Color":"#FFFF99"}) # Light yellow -> Cyto
    cellColor.ElementCC3D("Cell",{"Type":2,"Color":"#009900"}) # Dark Green   -> Apical
    cellColor.ElementCC3D("Cell",{"Type":3,"Color":"#990000"}) # Dark red     -> Basal
    cellColor.ElementCC3D("Cell",{"Type":4,"Color":"#0000FF"}) # Red          -> Cadherin8
    cellColor.ElementCC3D("Cell",{"Type":5,"Color":"#00E6E6"}) # Light blue   -> Lumen
    cellColor.ElementCC3D("TypesInvisibleIn3D",{"Types":"0,1,4,5"})   # Don't show Medium,Cyto, Cadherin8 and Lumen

   
    #CONTACT ENERGIES
    contact=CompuCell3DElement.ElementCC3D("Plugin",{"Name":"Contact"})
    #Medium
    contact.ElementCC3D("Energy",{"Type1":"Medium","Type2":"Medium"},0)
    contact.ElementCC3D("Energy",{"Type1":"Medium","Type2":"Cyto"},60)
    contact.ElementCC3D("Energy",{"Type1":"Medium","Type2":"Apical"},60)
    contact.ElementCC3D("Energy",{"Type1":"Medium","Type2":"Basal"},3)
    contact.ElementCC3D("Energy",{"Type1":"Medium","Type2":"Cadherin8"},8)
    #Cyto
    contact.ElementCC3D("Energy",{"Type1":"Cyto","Type2":"Cyto"},60)
    contact.ElementCC3D("Energy",{"Type1":"Cyto","Type2":"Apical"},60)
    contact.ElementCC3D("Energy",{"Type1":"Cyto","Type2":"Basal"},60)
    contact.ElementCC3D("Energy",{"Type1":"Cyto","Type2":"Cadherin8"},60)
    #Apical
    contact.ElementCC3D("Energy",{"Type1":"Apical","Type2":"Apical"},15)
    contact.ElementCC3D("Energy",{"Type1":"Apical","Type2":"Basal"},20)
    contact.ElementCC3D("Energy",{"Type1":"Apical","Type2":"Cadherin8"},20)
    #Basal
    contact.ElementCC3D("Energy",{"Type1":"Basal","Type2":"Basal"},20)
    contact.ElementCC3D("Energy",{"Type1":"Basal","Type2":"Cadherin8"},20)
    #Cadherin8
    contact.ElementCC3D("Energy",{"Type1":"Cadherin8","Type2":"Cadherin8"},Jll)
    #Lumen
    contact.ElementCC3D("Energy",{"Type1":"Lumen","Type2":"Lumen"},0)
    contact.ElementCC3D("Energy",{"Type1":"Lumen","Type2":"Medium"},60)
    contact.ElementCC3D("Energy",{"Type1":"Lumen","Type2":"Cyto"},60)
    contact.ElementCC3D("Energy",{"Type1":"Lumen","Type2":"Apical"},15)
    contact.ElementCC3D("Energy",{"Type1":"Lumen","Type2":"Basal"},20)
    contact.ElementCC3D("Energy",{"Type1":"Lumen","Type2":"Cadherin8"},20)
    #Neighbor order
    contact.ElementCC3D("NeighborOrder",{},CNOrder)
    
    #INTERNAL CONTACT ENERGIES:
    contactIn=CompuCell3DElement.ElementCC3D("Plugin",{"Name":"ContactInternal"})
    #Cyto
    contactIn.ElementCC3D("Energy", {"Type1":"Cyto", "Type2":"Apical"},0)
    contactIn.ElementCC3D("Energy", {"Type1":"Cyto", "Type2":"Basal" },0)
    contactIn.ElementCC3D("Energy", {"Type1":"Cyto", "Type2":"Cadherin8"},0)
    #Apical
    contactIn.ElementCC3D("Energy", {"Type1":"Apical", "Type2":"Basal"},2)
    contactIn.ElementCC3D("Energy", {"Type1":"Apical", "Type2":"Cadherin8"},0)
    #Basal
    contactIn.ElementCC3D("Energy", {"Type1":"Basal", "Type2":"Cadherin8"},0)
    #Lateral
    contactIn.ElementCC3D("Energy", {"Type1":"Cadherin8", "Type2":"Cadherin8"},0)
    #Lumen
    contactIn.ElementCC3D("Energy",{"Type1":"Lumen","Type2":"Lumen"},0)
    #Neighbor order
    contactIn.ElementCC3D("NeighborOrder",{},CINOrder)
    
    
    #OTHER PLUGINS
    pTracker=CompuCell3DElement.ElementCC3D("Plugin",{"Name":"PixelTracker"})
    boundaryPTracker=CompuCell3DElement.ElementCC3D("Plugin",{"Name":"BoundaryPixelTracker"})
    vlFlex=CompuCell3DElement.ElementCC3D("Plugin",{"Name":"VolumeLocalFlex"})
    coMass=CompuCell3DElement.ElementCC3D("Plugin",{"Name":"CenterOfMass"})
    neighborTracker=CompuCell3DElement.ElementCC3D("Plugin",{"Name":"NeighborTracker"})    

    CompuCellSetup.setSimulationXMLDescription(CompuCell3DElement)

import CompuCellSetup
import CompuCell

sim,simThread = CompuCellSetup.getCoreSimulationObjects()
configureSimulation(sim,Lx,Ly,Lz,Temp,Time,NOrder,CNOrder,CINOrder,debugFreq,Jll)

# Create extra player fields here or add attibutes
pyAttributeAdder,dictAdder = CompuCellSetup.attachDictionaryToCells(sim)
CompuCellSetup.initializeSimulationObjects(sim,simThread)

# Add Python steppables here
steppableRegistry = CompuCellSetup.getSteppableRegistry()

from isoCystSteppables import *
initCond=InitialConditions(sim,Time,cd,LamV,percCyto,percApical,percBasal,percLateral)
steppableRegistry.registerSteppable(initCond)

cInhibition=ContactInhibition(sim,1,gFactor,hillCoef,critAlpha,percApical,percBasal,percLateral)
steppableRegistry.registerSteppable(cInhibition)

mitosis=Mitosis(sim,1,cd,LamV,percApical,percBasal,percLateral)
steppableRegistry.registerSteppable(mitosis)

lFlux=LumenFlux(sim,1,LamV,Kl,ApArea)
steppableRegistry.registerSteppable(lFlux)

# Create extra fields here or add attributes
dim=sim.getPotts().getCellFieldG().getDim()

CompuCellSetup.mainLoop(sim,simThread,steppableRegistry)


