#include "environment.cpp"

using namespace std;

#define   MEDIUM 0
#define     CYTO 1
#define   APICAL 2
#define    BASAL 3
#define  LATERAL 4
#define    LUMEN 5
#define CTE 0.238732414638   // 3/(4*pi)

typedef struct { float meanSize,Radius,N; } toCalc;

void CalcFromVtk(string fileName,toCalc *out)
{
  uint k,l,m,count;
  CC3DEnvironment cc3d(fileName);
  
  float vol=0.;
  vector<Cell> cluster,latCells=cc3d.cellListByType(LATERAL);
  for(Cell cell : latCells)
    {
      cluster=cc3d.getClusterCells(cell.clusterId);
      for( Cell clus : cluster)
	vol+=clus.volume;
    }
    
  out->meanSize=pow(float(vol)/float(latCells.size()),1./3.);
  out->N=float(latCells.size());
  
  vector<Cell> lumCells=cc3d.cellListByType(LUMEN);
  for(Cell lum : lumCells)
    vol+=lum.volume;
  
  out->Radius=pow(CTE*vol,1./3.);
  
  cc3d.Delete();
}

int main(void)
{
  uint dt=500,
    tot=100000/dt;
  toCalc *vec=new toCalc[tot];
 
  omp_set_num_threads(15);
#pragma omp parallel default(none) shared(tot,dt,vec)
  {
    string aux,str="../LatticeData/Step_000000.vtk";
    toCalc uno;
    uint pos=str.size()-4,
      id=omp_get_thread_num(),
      numThreads=omp_get_num_threads();
    
    for(uint k=id;k<tot;k+=numThreads)
      {
	aux=to_string((k+1)*dt); str.replace(pos-aux.size(),aux.size(),aux);
	CalcFromVtk(str,&uno);
	
#pragma omp critical
	vec[k]=uno;
      }
  }

  ofstream data;
  data.open("../DataMeasured.txt");
  for(uint k=0;k<tot;k++)
    {
  data << (k+1)*dt << "\t" <<  vec[k].N  << "\t" << vec[k].meanSize << "\t" << vec[k].Radius << endl;
}

  data.close();
  
  delete(vec);
  return 0;
}
