from cc3d.cpp.PlayerPython import * 
from cc3d.core.PySteppables import *
from cc3d import CompuCellSetup
import numpy as np
from scipy import special, optimize
from scipy import integrate
from numpy import exp
from scipy import stats

# Use a user controlled field to track the center of mass (COM) of the bacterium and macrophage
class TrackCell_COM_Steppable(SteppableBasePy):
    def __init__(self, frequency=1):
        SteppableBasePy.__init__(self, frequency=frequency)
        self.create_scalar_field_py("Cell_Center_Track")

    def start(self):
        pass
        
    def step(self, mcs):
        if mcs % 2 == 0:  # update every 2 MCS
            COMfield = self.field.Cell_Center_Track
            # iterating over all cells in simulation        
            for cell in self.cell_list:
                #if cell.type == 1 or cell.type == 2:
                if cell.type == 2:
                    #print(cell.type,cell.id,"     ",cell.xCOM,cell.yCOM)
                    COMfield[int(cell.xCOM+0.5),int(cell.yCOM+0.5),0] = float(mcs)
        
