from cc3d.core.PySteppables import *

class CC3D_custom_cell_layoutSteppable(SteppableBasePy):

    def __init__(self,frequency=1):
        SteppableBasePy.__init__(self,frequency)

    def start(self):
        # create a custom intial layout off cells
        # 24 cells in a circle
        import math  # needed for the trig functions
        cellWidth  =  20  # how wide one cell is (pixels)
        circleWidth= 200  # how wide the circle of cells is (pixels)
        numCells   =  24  # number of cells in the circle
        # center point of the CC3D window:
        xMid=self.dim.x/2 # these will change automatically if the model's size is changed
        yMid=self.dim.y/2
        
        # a list of the cell types that we are using for the circle, used to assign types 
        # to the cells in the circle. Must be the all uppercase verson of the cell type
        # names in the .xml file. You can omit types if you want.
        cellTypeList=["self.CELLTYPE1","self.CELLTYPE2","self.CELLTYPE3"]
            
        for iAng in range(numCells):  # iterate over number of cells to create
            ang=2*3.14159/numCells*iAng # rotation angle, radians
            # location of the center of this cell
            xCellCenter=int(xMid - circleWidth/2.*math.cos(ang))
            yCellCenter=int(yMid - circleWidth/2.*math.sin(ang))
            # create a new CC3D cell, the cell type is assigned from the list of cell 
            # types using iAng iterator as the index into the list
            newCell = self.new_cell(eval(cellTypeList[ iAng %len(cellTypeList)])) 
            # Iterate over all possible pixels for this cell
            for ix in range(xCellCenter-cellWidth, xCellCenter+cellWidth+1):
                for iy in range(yCellCenter-cellWidth, yCellCenter+cellWidth+1):
                    # use this pixel if it is close enough to the cell's center
                    if sqrt((ix-xCellCenter)**2+(iy-yCellCenter)**2) <= cellWidth/2:
                        #this actually assigns this pixel to this cell
                        self.cell_field[ix:ix+1, iy:iy+1, 0] = newCell
                
            # done with pixels for this cell, set its target colume
            newCell.targetVolume = newCell.volume
            newCell.lambdaVolume = 1000

    def step(self,mcs):
        """
        type here the code that will run every frequency MCS
        :param mcs: current Monte Carlo step
        """
        #for cell in self.cell_list:
        #   print("cell.id=",cell.id)

    def finish(self):
        """
        Finish Function is called after the last MCS
        """

