
from cc3d.core.PySteppables import *

class fpp_projectSteppable(SteppableBasePy):

    def __init__(self,frequency=1):

        SteppableBasePy.__init__(self,frequency)

    def start(self):
        cell=self.new_cell(self.ECM)
        self.cell_field[0:self.dim.x, 0:50, 0] = cell
        #epithelia on top
        #create 30 cells
        xpos=0
        for numcells in range(30):
            lateral=self.new_cell(self.LATERAL)
            basal=self.new_cell(self.BASAL)
            self.reassign_cluster_id(basal,lateral.clusterId)
            apical=self.new_cell(self.APICAL)
            self.reassign_cluster_id(apical,lateral.clusterId)
            #create these cells in order first basal, then lateral then apical
            #assigning 40 pixels to basal, 120 to lateral and another 40 to apical 
            self.cell_field[xpos:xpos+10,50:54,0]=basal
            self.cell_field[xpos:xpos+10,54:66,0]=lateral
            self.cell_field[xpos:xpos+10,66:70,0]=apical
            xpos+=10      
            #volume properties
            lateral.targetVolume=120
            lateral.lambdaVolume=20
            basal.targetVolume=40
            basal.lambdaVolume=20
            apical.targetVolume=40
            apical.lambdaVolume=20
            apical.dict['constrict']=0
            apical.dict['graph']=0
            #freezing the first and last cells
            if(numcells==0 or numcells==29):
                lateral.lambdaVolume=100
                basal.lambdaVolume=100
                apical.lambdaVolume=100
            
        for cell in self.cell_list_by_type(self.APICAL):
            for neighbor, common_surface_area in self.get_cell_neighbor_data_list(cell):
                if neighbor:
                    if(neighbor.type==self.APICAL):
                        lambdaFP=10
                        targetDistance=6
                        self.focalPointPlasticityPlugin.createFocalPointPlasticityLink(cell,neighbor,lambdaFP,targetDistance,300.0)

        self.list_ids=[]
        self.list_del=[]
        self.counter=1
        for cell in self.cell_list_by_type(self.APICAL):
            self.list_ids.append(cell.id)
    def step(self,mcs):
        #sequential activation, every mcs=wave_speed, cell begins constricting gradually
        wave_speed=300
        relax_tm=50#arbitrary period chosen to activate cells after a while after initializing
        time=mcs-relax_tm
        if(mcs>=relax_tm):
            if(time%wave_speed==0):
                #pick cell
                id1=self.list_ids[self.counter]
                ap_cell=self.fetch_cell_by_id(id1)
                ap_cell.dict['constrict']=1
                ap_cell.dict['graph']=self.counter
                self.counter=min(self.counter+1,len(self.list_ids)-2)
                
        #this is where we implement the constriction 
        for ap_cell1 in self.cell_list_by_type(self.APICAL):           
            if(ap_cell1.dict['constrict']==1):
                for fppd in self.get_focal_point_plasticity_data_list(ap_cell1):
                    if(fppd.neighborAddress.dict['constrict']==1 and fppd.neighborAddress.dict['graph']>ap_cell1.dict['graph']):
                        #if cell and neighbor have been activated, begin constricting
                        #the second condition is used so that the same loop is not run in reverse for the neighbor and cell
                        lamb=fppd.lambdaDistance
                        lamb=min(lamb+0.05,100)
                        targetDistance=fppd.targetDistance
                        self.focalPointPlasticityPlugin.setFocalPointPlasticityParameters(ap_cell1, fppd.neighborAddress,lamb, targetDistance, 300.0)
                        #this is where we calculate the effect of lambda and targetDistance
                        #We will label this quantity as tension and we will look at -2*lambda*(actual_dist-target_distance)    
                        dist_s = sqrt((ap_cell1.xCOM - fppd.neighborAddress.xCOM) ** 2 + (ap_cell1.yCOM - fppd.neighborAddress.yCOM) ** 2)
                        ten = -2*lamb*(dist_s - targetDistance)
                        if(abs(ten)>400):
                            self.list_del.append((ap_cell1.id,fppd.neighborAddress.id))            
        for (id1,id2) in self.list_del:
            cell1 = self.fetch_cell_by_id(id1)
            cell2 = self.fetch_cell_by_id(id2)
            self.focalPointPlasticityPlugin.deleteFocalPointPlasticityLink(cell1, cell2)
            self.list_del.remove((id1,id2))
            
            
                

                
                    

    def finish(self):
        pass


        
