
def configure_simulation():

    from cc3d.core.XMLUtils import ElementCC3D
    
    cc3d=ElementCC3D("CompuCell3D",{"Revision":"20190811","Version":"4.0.0"})
    
    MetadataElmnt=cc3d.ElementCC3D("Metadata")
    
    # Basic properties simulation
    MetadataElmnt.ElementCC3D("NumberOfProcessors",{},"2")
    MetadataElmnt.ElementCC3D("DebugOutputFrequency",{},"10")
    # MetadataElmnt.ElementCC3D("NonParallelModule",{"Name":"Potts"})
    
    potts=cc3d.ElementCC3D("Potts")
    
    # Basic properties of CPM (GGH) algorithm
    potts.ElementCC3D("Dimensions",{"x":70,"y":160,"z":70})
    potts.ElementCC3D("Steps",{},10000)
    potts.ElementCC3D("Temperature",{},15)#original 30   
    potts.ElementCC3D("NeighborOrder",{},3)
    
    PluginElmnt=cc3d.ElementCC3D("Plugin",{"Name":"CellType"})
    
    # Listing all cell types in the simulation
    PluginElmnt.ElementCC3D("CellType", {"TypeName":"Medium","TypeId":"0"})
    PluginElmnt.ElementCC3D("CellType", {"TypeName":"StemCell" ,"TypeId":"1"})
    PluginElmnt.ElementCC3D("CellType", {"TypeName":"BM" ,"TypeId":"2"})    # Meschymal cells
    PluginElmnt.ElementCC3D("CellType", {"TypeName":"CT" ,"TypeId":"3"})    # central tube cells
    PluginElmnt.ElementCC3D("CellType", {"TypeName":"Paneth" ,"TypeId":"4"})
    PluginElmnt.ElementCC3D("CellType", {"TypeName":"Goblet" ,"TypeId":"5"})    
    PluginElmnt.ElementCC3D("CellType", {"TypeName":"Enterocyte" ,"TypeId":"6"})
    
    contact=cc3d.ElementCC3D("Plugin",{"Name":"Contact"})
    contact.ElementCC3D("Energy", {"Type1":"Medium", "Type2":"Medium"},0)
    contact.ElementCC3D("Energy", {"Type1":"Medium", "Type2":"StemCell"},8)
    contact.ElementCC3D("Energy", {"Type1":"Medium", "Type2":"BM"},10)
    contact.ElementCC3D("Energy", {"Type1":"StemCell",  "Type2":"StemCell"},5 )
    contact.ElementCC3D("Energy", {"Type1":"StemCell",  "Type2":"BM"},1)
    contact.ElementCC3D("Energy", {"Type1":"BM",  "Type2":"BM"},0)
    contact.ElementCC3D("Energy", {"Type1":"CT",  "Type2":"StemCell"},1)
    contact.ElementCC3D("Energy", {"Type1":"CT",  "Type2":"Medium"},10)
    contact.ElementCC3D("Energy", {"Type1":"CT",  "Type2":"BM"},10)
    contact.ElementCC3D("Energy", {"Type1":"CT",  "Type2":"CT"},0)
    contact.ElementCC3D("Energy", {"Type1":"Paneth", "Type2":"Medium"},8)
    contact.ElementCC3D("Energy", {"Type1":"Paneth", "Type2":"StemCell"},5)
    contact.ElementCC3D("Energy", {"Type1":"Paneth", "Type2":"BM"},1)
    contact.ElementCC3D("Energy", {"Type1":"Paneth", "Type2":"CT"},1)
    contact.ElementCC3D("Energy", {"Type1":"Paneth", "Type2":"Paneth"},5)
    contact.ElementCC3D("Energy", {"Type1":"Goblet", "Type2":"Medium"},8)
    contact.ElementCC3D("Energy", {"Type1":"Goblet", "Type2":"StemCell"},5)
    contact.ElementCC3D("Energy", {"Type1":"Goblet", "Type2":"BM"},1)
    contact.ElementCC3D("Energy", {"Type1":"Goblet", "Type2":"CT"},1)
    contact.ElementCC3D("Energy", {"Type1":"Goblet", "Type2":"Paneth"},5)
    contact.ElementCC3D("Energy", {"Type1":"Goblet", "Type2":"Goblet"},5)
    contact.ElementCC3D("Energy", {"Type1":"Enterocyte", "Type2":"Medium"},8)
    contact.ElementCC3D("Energy", {"Type1":"Enterocyte", "Type2":"StemCell"},5)
    contact.ElementCC3D("Energy", {"Type1":"Enterocyte", "Type2":"BM"},1)
    contact.ElementCC3D("Energy", {"Type1":"Enterocyte", "Type2":"CT"},1)
    contact.ElementCC3D("Energy", {"Type1":"Enterocyte", "Type2":"Paneth"},5)
    contact.ElementCC3D("Energy", {"Type1":"Enterocyte", "Type2":"Goblet"},5)    
    contact.ElementCC3D("Energy", {"Type1":"Enterocyte", "Type2":"Enterocyte"},5)       
    contact.ElementCC3D("NeighborOrder",{},5)
    
    SteppableElmnt=cc3d.ElementCC3D("Steppable",{"Type":"DiffusionSolverFE"})    
    DiffusionFieldElmnt=SteppableElmnt.ElementCC3D("DiffusionField",{"Name":"WNT"})
    DiffusionDataElmnt=DiffusionFieldElmnt.ElementCC3D("DiffusionData")
    DiffusionDataElmnt.ElementCC3D("FieldName",{},"WNT")
    DiffusionDataElmnt.ElementCC3D("GlobalDiffusionConstant",{},"0.0")
    DiffusionDataElmnt.ElementCC3D("GlobalDecayConstant",{},"0")
    DiffusionDataElmnt.ElementCC3D("InitialConcentrationExpression",{},"160-y")
        
    volume = cc3d.ElementCC3D("Plugin",{"Name":"VolumeLocalFlex"})
    ntp = cc3d.ElementCC3D("Plugin",{"Name":"NeighborTracker"})
    com = cc3d.ElementCC3D("Plugin",{"Name":"CenterOfMass"})

    uipd = cc3d.ElementCC3D("Steppable",{"Type":"UniformInitializer"})
    region = uipd.ElementCC3D("Region")
    region.ElementCC3D("BoxMin",{"x":6,  "y":6,  "z":6})
    region.ElementCC3D("BoxMax",{"x":65,  "y":125,  "z":65})
    region.ElementCC3D("Types",{},"StemCell")
    region.ElementCC3D("Width", {},10)

    CompuCellSetup.setSimulationXMLDescription(cc3d)    

#            
from cc3d import CompuCellSetup
        
configure_simulation()            

        
from colonic_cryptSteppables import *
 
CompuCellSetup.register_steppable(steppable=InitialConditionSteppable(frequency=1))    

CompuCellSetup.register_steppable(steppable=GrowthSteppable(frequency=1))

CompuCellSetup.register_steppable(steppable=DeltaNotchClassSteppable(frequency=1))

CompuCellSetup.register_steppable(steppable=MitosisSteppable(frequency=1))

# CompuCellSetup.register_steppable(steppable=ExtraFieldsSteppable(frequency=1))

CompuCellSetup.run()
