
def configureSimulation():

    from cc3d.core.XMLUtils import ElementCC3D
    
    CompuCell3DElmnt=ElementCC3D("CompuCell3D",{"Revision":"20190604","Version":"4.0.0"})
    
    PottsElmnt=CompuCell3DElmnt.ElementCC3D("Potts")
    
    # Basic properties of CPM (GGH) algorithm
    PottsElmnt.ElementCC3D("Dimensions",{"x":"42","y":"42","z":"1"})
    PottsElmnt.ElementCC3D("Steps",{},"100000")
    PottsElmnt.ElementCC3D("Temperature",{},"10.0")
    PottsElmnt.ElementCC3D("NeighborOrder",{},"2")
    PottsElmnt.ElementCC3D("Boundary_x",{},"Periodic")
    PottsElmnt.ElementCC3D("Boundary_y",{},"Periodic")
    
    PluginElmnt=CompuCell3DElmnt.ElementCC3D("Plugin",{"Name":"CellType"})
    
    # Listing all cell types in the simulation
    PluginElmnt.ElementCC3D("CellType",{"TypeId":"0","TypeName":"Medium"})
    PluginElmnt.ElementCC3D("CellType",{"TypeId":"1","TypeName":"CellA"})
    
    PluginElmnt_1=CompuCell3DElmnt.ElementCC3D("Plugin",{"Name":"Volume"})
    PluginElmnt_1.ElementCC3D("VolumeEnergyParameters",{"CellType":"CellA","LambdaVolume":"5.0","TargetVolume":"50"})
        
    # Module tracking center of mass of each cell
    
    PluginElmnt_3=CompuCell3DElmnt.ElementCC3D("Plugin",{"Name":"NeighborTracker"})
    
    # Module tracking neighboring cells of each cell
    
    PluginElmnt_4=CompuCell3DElmnt.ElementCC3D("Plugin",{"Name":"Contact"})
    # Specification of adhesion energies
    PluginElmnt_4.ElementCC3D("Energy",{"Type1":"Medium","Type2":"Medium"},"10.0")
    PluginElmnt_4.ElementCC3D("Energy",{"Type1":"Medium","Type2":"CellA"},"5.0")
    PluginElmnt_4.ElementCC3D("Energy",{"Type1":"CellA","Type2":"CellA"},"5.0")
    PluginElmnt_4.ElementCC3D("NeighborOrder",{},"4")
    
    SteppableElmnt=CompuCell3DElmnt.ElementCC3D("Steppable",{"Type":"UniformInitializer"})
    
    # Initial layout of cells in the form of rectangular slab
    RegionElmnt=SteppableElmnt.ElementCC3D("Region")
    RegionElmnt.ElementCC3D("BoxMin",{"x":"0","y":"0","z":"0"})
    RegionElmnt.ElementCC3D("BoxMax",{"x":"42","y":"42","z":"1"})
    RegionElmnt.ElementCC3D("Width",{},"7")
    RegionElmnt.ElementCC3D("Types",{},"CellA")

    CompuCellSetup.setSimulationXMLDescription(CompuCell3DElmnt)    

            
from cc3d import CompuCellSetup
        

configureSimulation()            
            

from DeltaNotchSteppables import DeltaNotchSteppable
CompuCellSetup.register_steppable(steppable=DeltaNotchSteppable(frequency=1))

        
from DeltaNotchSteppables import VisualizationSteppable
CompuCellSetup.register_steppable(steppable=VisualizationSteppable(frequency=1))

CompuCellSetup.run()
