from cc3d.core.PySteppables import *
import numpy as np

ModelString = '''        
        model DNModel()
        
        //State Variables and Transitions
        V1: -> D ;  v*(1/(1+b*N^h)-D) ; 
        V2: -> N ;  Davg^k/(a+Davg^k)-N; 
        
        //Parameters
        v = 1 ; 
        b = 100 ; 
        h = 2 ; 
        k = 2 ;
        a = 0.01 ;        
        
        // Initial Conditions ;
        D = 0.4 ;
        N = 0.5 ;   
        Davg = 0.5 ; 
end'''

class DeltaNotchSteppable(SteppableBasePy):
    def __init__(self,frequency=1):
        SteppableBasePy.__init__(self,frequency)

    def start(self):       
        self.add_antimony_to_cell_types(model_string=ModelString, model_name='DN', cell_types=[self.CELLA],
                                step_size=0.2)
                     
        for cell in self.cell_list:
            cell.sbml.DN['D'] = np.random.uniform(0.9,1.0)
            cell.sbml.DN['N'] = np.random.uniform(0.9,1.0)
            cell.targetVolume = cell.volume
            cell.lambdaVolume = 5
            
    def step(self,mcs):  
        for cell in self.cell_list:
            if cell.yCOM < 40:
                Davg=0; nn=0.0
                for (neighbor,common_surface_area) in self.get_cell_neighbor_data_list(cell):
                    if neighbor:
                        Davg+=neighbor.sbml.DN['D']
                        nn+=1.0
                if nn:
                    cell.sbml.DN['Davg']=Davg/nn
                
        self.timestep_sbml()    
     
#       
class VisualizationSteppable(SteppableBasePy):
    def __init__(self, frequency=1):
        SteppableBasePy.__init__(self, frequency)  
        self.N = self.create_scalar_field_cell_level_py("Notch")
        self.D = self.create_scalar_field_cell_level_py("Delta")

    def step(self, mcs):
        self.N.clear()
        self.D.clear()  
        for cell in self.cell_list:
            if cell.yCOM < 40:
                self.N[cell]=cell.sbml.DN['N']
                self.D[cell]=cell.sbml.DN['D']
            
        
        
class GrowthSteppable(SteppableBasePy):
    def __init__(self,frequency=1):
        SteppableBasePy.__init__(self, frequency)

    def step(self, mcs):
    
        for cell in self.cell_list:
            if cell.sbml.DN['N']>0.9 and cell.yCOM < 40:
                cell.targetVolume += 0.1    
            
            if cell.yCOM > 150:
                cell.targetVolume = 0

        
class MitosisSteppable(MitosisSteppableBase):
    def __init__(self,frequency=1):
        MitosisSteppableBase.__init__(self,frequency)

    def step(self, mcs):

        cells_to_divide=[]
        for cell in self.cell_list:
            if cell.volume>100:
                cells_to_divide.append(cell)

        for cell in cells_to_divide:
            self.divide_cell_random_orientation(cell)
            # Other valid options
            # self.divide_cell_orientation_vector_based(cell,1,1,0)
            # self.divide_cell_along_major_axis(cell)
            # self.divide_cell_along_minor_axis(cell)

    def update_attributes(self):
        # reducing parent target volume
        self.parent_cell.targetVolume /= 2.0                  

        self.clone_parent_2_child()            


        # for more control of what gets copied from parent to child use cloneAttributes function
        # self.clone_attributes(source_cell=self.parent_cell, target_cell=self.child_cell, no_clone_key_dict_list=[attrib1, attrib2]) 
        
#         if self.parent_cell.type==1:
#             self.child_cell.type=2
#         else:
#             self.child_cell.type=1

        