from cc3d.core.PySteppables import *
import numpy as np

class DeltaNotchSteppable(SteppableBasePy):
    def __init__(self,frequency=1):
        SteppableBasePy.__init__(self,frequency)

    def start(self):       
        model_file = 'Simulation/DN_Collier.sbml'   
        self.add_sbml_to_cell_types(model_file=model_file, model_name='DN', cell_types=[self.CELLA], step_size=0.2)
                     
        for cell in self.cell_list:
            cell.sbml.DN['D'] = np.random.uniform(0.9,1.0)
            cell.sbml.DN['N'] = np.random.uniform(0.9,1.0)
            cell.targetVolume = 50
            cell.lambdaVolume = 2
            
    def step(self,mcs):
        for cell in self.cell_list:
            Davg=0; nn=0.0
            for (neighbor,common_surface_area) in self.get_cell_neighbor_data_list(cell):
                if neighbor:
                    Davg+=neighbor.sbml.DN['D']
                    nn+=1.0
            if nn:
                cell.sbml.DN['Davg']=Davg/nn
        self.timestep_sbml()    
     
#       
class VisualizationSteppable(SteppableBasePy):
    def __init__(self, frequency=1):
        SteppableBasePy.__init__(self, frequency)  
        self.N = self.create_scalar_field_cell_level_py("Notch")
        self.D = self.create_scalar_field_cell_level_py("Delta")

    def step(self, mcs):
        self.N.clear()
        self.D.clear()  
        for cell in self.cell_list:
            self.N[cell]=cell.sbml.DN['N']
            self.D[cell]=cell.sbml.DN['D']
            