###################################################################################################
#     The code was writen by Gilberto L Thomas for the 15th CC3D Wokshop. It is adapted from a previous one written 
#  between 2014-2015 mainly by I. Fortuna and Gilberto L. Thomas of the UFRGS, Brazil.
####################################################################################################
#
# Generic Python housekeeping steps -- loads utility functions
#
from cc3d import CompuCellSetup
from cc3d.core.PySteppables import *
import sys
import os
from os import makedirs
import os.path
from numpy import *
from math import *
from random import *
#
# Defines the Cell steppable class, which creates a cell object of type CYTO and its NUCL, CYTO and FRONT compartments.
#
class Cell(SteppableBasePy):
   def __init__(self,frequency,_phiF,_phiN,_cellVol):
      SteppableBasePy.__init__(self,frequency) 
   #
      self.phiN=_phiN;  self.phiF=_phiF  
      self.phiC=1. - self.phiN - self.phiF   
      self.cellVol=_cellVol  

   def start(self): 
        # Assigns initial volume parameters for CYTO compartment
        for cell in self.cell_list_by_type(self.CYTO):
            cell.targetVolume=int(self.cellVol*(self.phiC+self.phiF))
            cell.lambdaVolume=10
            for neighbor, common_surface_area in self.get_cell_neighbor_data_list(cell):
                if neighbor and neighbor.type==self.NUCL:  
                  neighbor.targetVolume=int(self.cellVol*self.phiN)+.5
                  neighbor.lambdaVolume=10
                  reassignIdFlag=self.inventory.reassignClusterId(neighbor,cell.clusterId)
                  break
            # Make the NUCLcell  generalized cell object a compartment of the current cell.
   #
   def step(self,mcs): 
      pass
      #
      #      The next loop creates the FRONT compartment from part of the 
      # CYTO compartment of the cell object of type CYTO.
      #
      for cell in self.cell_list_by_type(self.CYTO):          # Identifies any cell(s) of type CYTO. 
         nFRONT=0;   FRONTvol=0.0;   NUCLvol=0.0    # Counters to measure the current compartment volumes 
         compList = self.get_cluster_cells(cell.clusterId) # Creates a list of the compartments in the cell
         for compCell in compList:           # Iterates over the compartments in the cell.
            if compCell.type==self.NUCL: 
               NUCLcell=compCell
               NUCLvol=compCell.targetVolume
            elif compCell.type==self.FRONT: 
               FRONTcell=compCell
               FRONTvol+=compCell.targetVolume
               nFRONT+=1
         CELLvol = cell.targetVolume + FRONTvol + NUCLvol # The total actual cell volume (CELLvol) is the sum of 
         pFRONT = 0.1*(1.- FRONTvol/CELLvol/self.phiF)     # Probability to grow the FRONT  (max= phiF x total cell volume).
         if pFRONT>0:  # The FRONT compartment can grow
            pList=[]   # List of all CYTO compartment  boundary voxels.
            pixel_list = self.get_cell_boundary_pixel_list(cell)
            for pixel_data in pixel_list: # Iterates over the list of all CYTO compartment boundary voxels.
               if pixel_data.pixel.z==1:  # Only the CYTO compartment boundary voxels in contact to SUBS_A
                  pList.append([pixel_data.pixel.x, pixel_data.pixel.y, 1]) #  Put them in a list
            shuffle(pList)           # Randomizes the list
            for x,y,z in pList:      # Iterates through the shuffled list of pixels
               if (random()<pFRONT): # Reassign the current CYTO voxel to the FRONT compartment with probability pFRONT.
                  if not nFRONT:     # If the cell does not currently have a FRONT compartment.
                     FRONTcell=self.new_cell(self.FRONT) # Creates a generalized cell object FRONTcell 
                     self.cell_field[x,y,z]=FRONTcell          # Assigns the current voxel to be part 
                     reassignIdFlag=self.inventory.reassignClusterId(FRONTcell,cell.clusterId)  #  Makes the FRONTcell generalized cell
                                                                                                                                     #  object a compartment of the cell.
                     FRONTcell.targetVolume=1.5   # Assigns the initial target volume 
                     FRONTcell.lambdaVolume=10  # Assigns the inverse compressibility 
                     cell.targetVolume-=1.5           # Decreases the volume of the cell by the amount of
                     nFRONT+=1                           # Count the number of FRONT compartments in the cell
                     FRONTvol=1.5 
                  else:  # If the cell already has a FRONT compartment.
                     self.cell_field[x,y,z]=FRONTcell # Assigns the current voxel  to FRONT
                     FRONTcell.targetVolume+=1.   # Increases the FRONT target volume 
                     cell.targetVolume-=1.             # Decreases the volume of the cell 
                     FRONTvol+=1.                       # Increases the FRONT  volume
                  pFRONT = 0.1*(1.- FRONTvol/CELLvol/self.phiF)
#
# Defines the Calc steppable class, which measures the properties of the migrating cell.
#
class Calc(SteppableBasePy):
    #
    #    The following defines the output files, the plots to be displayed, 
    # and the preliminary analysis of the cell's properties and movements
    #
   def __init__(self,frequency,_phiF,_phiN,_lambCHEM,_cellRad,_g1Flag,_g2Flag,_x1,_y1,_dT): 
      SteppableBasePy.__init__(self,frequency) 
      #
      self.phiF=_phiF;    self.phiN=_phiN
      self.phiC=1. - self.phiF - self.phiN
      self.lambCHEM=_lambCHEM 
      self.deltaT=_dT 
      self.cellRad=_cellRad 
      self.g1Flag=_g1Flag;  self.g2Flag=_g2Flag # Turns on the display of graphics in Player 
                                                                          # as specified by the CellMig3D_Demo.py file. 
      self.x1=_x1;    self.y1=_y1 # Sets the initial x and y center-of-mass positions of the cell .object 
                                                    # as specified by the CellMig3D_Demo.py file.
   #
   # The "start" function is run once at the beginning of a simulation.
   # It generates the output files and plot windows.
   #
   def start(self):
      #
      Dir=self.output_dir #      Defines the output directory for the files.
      output="_R"+str(self.cellRad) + "_pF" + str(self.phiF) + "_lC" + str(self.lambCHEM) + "_dT" + str(self.deltaT)
      #
      self.SB=output + "_SBAn.dat" #  Creates full file name for symmetry breaking data
      self.brokenSB="_BROKEN" + output + "_SBAn.dat" #  Creates full file name for simulations in which the FRONT 
                                                                                        # compartment separates from the CYTO compartment.
      #
      self.SBfileName=Dir + self.SB #  Creates full path name for symmetry breaking data.
      self.brokenSBfileName=Dir + self.brokenSB #  Create full name for  simulations in which the FRONT 
                                                                            # compartment separates from the CYTO compartment.  
      SBfile=open(self.SBfileName,'w') # Creates the file for symmetry breaking data for write access.
                                                    #WARNING: to run in nanoHUB, we replace 'x' for 'w'
                                                    #
      SBfile.write("%s\n" % ("time    dcm_F_CN    zposN    Cont_CF     phi3d_C    phi3d_F    phi3d_N    cellVol"))
      SBfile.close() # Forces storage of the information by closing the file.
      #
      self.CD=output + "_Displacement.dat" #  Creates full file name for centers-of-mass data on the compartments
      self.brokenCD="_BROKEN" + output + "_Displacement.dat" #  Creates full file name for simulations in which the 
                                                                                # FRONT compartment separates from the CYTO compartment.
      #
      self.CDfileName=Dir + self.CD #      Creates full path name for centers-of-mass data.
      self.brokenCDfileName=Dir + self.brokenCD #  Creates full path name for simulations in which the  FRONT
                                                                            #  compartment separates from the CYTO compartment.
      CDfile=open(self.CDfileName,'w') # Creates the file for centers-of-mass data for write access.
                                                    #WARNING: to run in nanoHUB, we replace 'x' for 'w'
                                                    #
      CDfile.write("%s\n" % ("time   xposC       yposC      zposC       xposF      yposF     zposF       xposN       yposN      zposN       xposCN      yposCN    zposCN"))
      CDfile.close() # Forces storage of the information by closing the file.
      #
      # Prints file names and path to console for reference.
      #
      print ("**********************")
      print ("Dir: ",Dir) # Prints path to data files
      print ("SBfileName: ",self.SBfileName)   # Prints name of symmetry breaking data file.
      print ("CDfileName: ", self.CDfileName) # Prints name of centers-of-mass data file.
      print ("**********************")
      if self.g1Flag=='yes': # If the flag for plotting displacements is set.
         
      #  CELL DISPLACEMENT
      #  plot 1 [NUCL trajectory]
         
         self.plot_1=self.add_new_plot_window(title='Nucleus Trajectory',
                                                             x_axis_title='x (pixel)',y_axis_title='y (pixel)', 
                                                             x_scale_type='linePlotWindowInterfacear',y_scale_type='linear') 
                                                             # Opens and names plot window.
         self.plot_1.add_plot("trajN",style='Dots',color='red',size=3) # Defines color of (0,0) reference point.
         self.plot_1.add_plot("trajScale",style='Dots',color='black') # Hides max and min reference points.
         self.plot_1.add_data_point("trajN",0,0) # Puts a point at the 0,0 position on the graph.
         self.plot_1.add_data_point("trajScale",-2.*self.dim.x/3/self.cellRad,-2.*self.dim.y/3/self.cellRad) 
                        # Puts a point at the minimum position to set graph axis scales.
         self.plot_1.add_data_point("trajScale",2.*self.dim.x/3/self.cellRad,2.*self.dim.y/3/self.cellRad) 
                        # Puts a point at the maximum position to set graph axis scales.
         self.plot_1.show_all_plots() # Displays plot to Player..
        #
      if self.g2Flag=='yes': # If the flag for plotting cell properties is set.
         #
         # plotWindow 3 [distance between FRONT and combined CYTO+NUCL combined centers-of-mass].
         #
         self.plot_3=self.add_new_plot_window(title='Distance F-CN',x_axis_title='time [mcs]',y_axis_title='CM distances',
                                                             x_scale_type='linear' ,y_scale_type='linear')
         self.plot_3.add_plot("dCM",style='Lines',color='red',size=3) 
      #
      #      Now starts the cell and compartment centers-of-mass calculations. 
      #      Creates and zeros vectors to store the (X,Y,Z) coordinates at time t and at time t+dTn 
      # and the displacement during this interval.
      #      Vector names: Let "..." represent the compartments (C,F,N). 
      #      Then, self.opos... -> coordinates at t; self.pos... -> coordinates at t+dT; 
      # and self.desl... -> displacement between t and t+dT.
      #
      self.oposC=[.0,.0,.0];   self.posC=[.0,.0,self.cellRad];    self.deslC=[.0,.0,.0]
      self.oposF=[.0,.0,.0];   self.posF=[.0,.0,self.cellRad];    self.deslF=[.0,.0,.0]
      self.oposN=[.0,.0,.0];   self.posN=[.0,.0,self.cellRad];    self.deslN=[.0,.0,.0]
      #
      #      For each cell in the cell list (only one in this simulation) store the center of mass position as 
      # a placeholder at t=0 to compare to later positions of each compartment.
      #
      for cell in self.cell_list_by_type(self.CYTO): # Loop over all cells
         self.oposC=[cell.xCOM,cell.yCOM,cell.zCOM] #    Store the CYTO center of mass at t=0
         self.oposF=[cell.xCOM,cell.yCOM,cell.zCOM] #    Store the FRONT center of mass at t=0 
         self.oposN=[cell.xCOM,cell.yCOM,cell.zCOM] #    Store the NUCL center of mass at t=0 
      self.phiTarget=[self.phiC,self.phiF,self.phiN] # Here we store the volume fraction of each compartment 
                                       #with respect to the whole call.
    #
    #    The "step" function analyzes the cell shape and positions and outputs the results to Player plots 
    # and to the output files once every deltaT as defined in the CellMig3D_Demo.py file.
    #
   def step(self,mcs):  # The step function is called every mcs.
      # 
      # Cell movement analysis.
      #
      if (mcs%self.deltaT==0): # The calculations occur every deltaT mcs.
         self.phi3d=[.0,.0,.0] #    Creates and zeros a vector to store [phiCYTO,phiFRONT,phiNUCL]; 
                                       # fraction of compartment volumes.
         self.Cont_CF=.0 # Creates and zeros a variable to count the number of CYTO-FRONT contact voxels.
         #
         for cell in self.cell_list_by_type(self.CYTO): #      Loop over all cells   
            #     The next 3 lines calculate the displacement of the current 
            # CYTO compartment cm position from the its previous position.
            self.deslC[0]=cell.xCOM-self.oposC[0]  
            self.deslC[1]=cell.yCOM-self.oposC[1]            
            self.deslC[2]=cell.zCOM-self.oposC[2]
            self.oposC[0]=cell.xCOM;  self.oposC[1]=cell.yCOM;  self.oposC[2]=cell.zCOM  #     Stores the current 
                                                  # CYTO cm position as the previous position.
            #    The next 4 lines adjust the displacements for the situation where the CYTO cm 
            # crosses one of the xy periodic boundaries.                                       
            if   self.deslC[0]<-self.dim.x/2.: self.deslC[0]+=self.dim.x 
            elif self.deslC[0]> self.dim.x/2.: self.deslC[0]-=self.dim.x 
            if   self.deslC[1]<-self.dim.y/2.: self.deslC[1]+=self.dim.y 
            elif self.deslC[1]> self.dim.y/2.: self.deslC[1]-=self.dim.y 
            #
            #    The next 3 lines accumulate the total displacement of the CYTO compartment 
            # as if the cell object were crawling in an infinte lattice rather than a periodic lattice.
            self.posC[0]+=self.deslC[0] 
            self.posC[1]+=self.deslC[1] 
            self.posC[2]+=self.deslC[2] 
            self.phi3d[0]+=cell.volume  #      Accumulates the cell object volume in phi3d[0].
#
            cellNeighborList=self.get_cell_neighbor_data_list(cell) #     Creates a list of the 
                                         # generalized cell and compartment objects adjacent to the cell object.
            for neighbor, common_surface_area in cellNeighborList: #    Iterate over the neighbors of the cell object.
               if neighbor:  #    If the neighbor object is not "Medium".
                  Type2name=neighbor.type # Store the type of the neighbor object.
                  if (Type2name==self.FRONT):   self.Cont_CF+=common_surface_area #      Accumulates 
                                       # the contact area between the cell object and the FRONT compartment.
            # 
            #    Calculates the FRONT (X,Y,Z) displacement, in the same way as above (lines 406-426).
            #
            compList=self.get_cluster_cells(cell.clusterId) #     Stores list of the compartments 
                                                                                           # of the cell object.
            for compCell in compList:               
               if  compCell.type==self.FRONT:             
                  self.deslF[0]=compCell.xCOM-self.oposF[0]
                  self.deslF[1]=compCell.yCOM-self.oposF[1]
                  self.deslF[2]=compCell.zCOM-self.oposF[2]
                  self.oposF[0]=compCell.xCOM;     self.oposF[1]=compCell.yCOM;    self.oposF[2]=compCell.zCOM
                  if   self.deslF[0]<-self.dim.x/2.: self.deslF[0]+=self.dim.x
                  elif self.deslF[0]> self.dim.x/2.: self.deslF[0]-=self.dim.x
                  if   self.deslF[1]<-self.dim.y/2.: self.deslF[1]+=self.dim.y
                  elif self.deslF[1]> self.dim.y/2.: self.deslF[1]-=self.dim.y
                  self.posF[0]+=self.deslF[0]
                  self.posF[1]+=self.deslF[1]
                  self.posF[2]+=self.deslF[2]
                  self.phi3d[1]+=compCell.volume
               elif compCell.type==self.NUCL:  #    Here it calculates the NUCL displacement, 
                                                               # in the same way as above (lines 406-426).
                  self.deslN[0]=compCell.xCOM-self.oposN[0]
                  self.deslN[1]=compCell.yCOM-self.oposN[1]
                  self.deslN[2]=compCell.zCOM-self.oposN[2]
                  self.oposN[0]=compCell.xCOM;     self.oposN[1]=compCell.yCOM;    self.oposN[2]=compCell.zCOM
                  if   self.deslN[0]<-self.dim.x/2.: self.deslN[0]+=self.dim.x
                  elif self.deslN[0]> self.dim.x/2.: self.deslN[0]-=self.dim.x
                  if   self.deslN[1]<-self.dim.y/2.: self.deslN[1]+=self.dim.y
                  elif self.deslN[1]> self.dim.y/2.: self.deslN[1]-=self.dim.y
                  self.posN[0]+=self.deslN[0]
                  self.posN[1]+=self.deslN[1]
                  self.posN[2]+=self.deslN[2]
                  self.phi3d[2]+=compCell.volume
         #
         cellVol=sum(self.phi3d) # Sums all compartment volumes.
         posCN=[.0,.0,.0] # Creates and zeros a vector to record the position of CYTO+NUCL (CN) combined cm.
         d_F_CN=.0 # Creates and zeros a variable to store the distance between the cm of FRONT and (CYTO+NUCL).
         for i in range(3): # Calculates the distance between F and CN
             posCN[i]= (self.posC[i]*self.phi3d[0]+self.posN[i]*self.phi3d[2])/(self.phi3d[0]+self.phi3d[2])
             if not i==2: d_F_CN+=(posCN[i]-self.posF[i])*(posCN[i]-self.posF[i])
         # Scales all the calculations by the cell size, CELLRad.
         xC=self.posC[0]/self.cellRad ; yC=self.posC[1]/self.cellRad; zC=self.posC[2]/self.cellRad
         xF=self.posF[0]/self.cellRad ; yF=self.posF[1]/self.cellRad; zF=self.posF[2]/self.cellRad
         xN=self.posN[0]/self.cellRad ; yN=self.posN[1]/self.cellRad; zN=self.posN[2]/self.cellRad
         xCN=posCN[0]/self.cellRad ; yCN=posCN[1]/self.cellRad; zCN=posCN[2]/self.cellRad
         d_F_CN=sqrt(d_F_CN)/self.cellRad # Calculate RMS displacement scaled by cell size.
         hN=self.posN[2]/self.cellRad           # Calculate rescaled z position of NUCL compartment. 
         self.phi3d/=sum(self.phi3d)            # Calculates the volume fraction for each compartment.
         #
         # Plot and store the data.
         #
         if (self.g1Flag=='yes'): # Display if the first display flag is set.
            self.plot_1.add_data_point("trajN",self.posN[0]/self.cellRad,self.posN[1]/self.cellRad) # Plots 
                                      # the xy-projection of the NUCL compartment.
            self.plot_1.show_all_plots() # Update plots in Player
         #
         if (self.g2Flag=='yes'): # Display if the second display flag is set.
            self.plot_3.add_data_point("dCM",mcs,d_F_CN) # Plots the dist between the cm of FRONT and (CYTO+NUCL).
            self.plot_3.show_all_plots() #    Update plots in Player.
         #
         #     Records output data to previously opened files--see above for meaning of columns.
         #
         SBfile=open(self.SBfileName,'a')  # Reopens file for symmetry breaking data for append.
         SBfile.write("%d %.8f %.8f %d %.8f %.8f %.8f %d  \n" % (mcs,d_F_CN,hN,self.Cont_CF,
                                                                                                self.phi3d[0],self.phi3d[1],self.phi3d[2],cellVol)) 
                                          # Store current symmetry breaking data to symmetry breaking data file
         SBfile.close()# Force storage of the information by closing the file.
         CDfile=open(self.CDfileName,'a')  #    Reopens file for centers-of-mass data for append.
         CDfile.write("%d %.8f %.8f %.8f %.8f %.8f %.8f %.8f %.8f %.8f %.8f %.8f %.8f \n" 
                            % (mcs ,xC,yC,zC,xF,yF,zF,xN,yN,zN,xCN,yCN,zCN ))
                                          #     Store current centers-of-mass data to cm data file
         CDfile.close() #     Force storage of the information by closing the file.   
         #
         #     The lines below check if the cell's FRONT compartment has detached from the cell's CYTO compartment.
         # If so, the simulation has failed and it renames the output files to identify the detachment and halts
         # the simulation so that the simulation can resume with a different set of parameters.
         #
         if not self.Cont_CF and mcs > 10: #    If the FRONT compartment is detached from the CYTO compartment 
                                                             # of the cell and the time is greater than 10 mcs.
            os.system("move "+'"'+self.CDfileName+'"'+" "+'"'+self.brokenCDfileName+'"') 
                    # Renames the symmetry-breaking data file.
            os.system("move "+'"'+self.SBfileName+'"'+" "+'"'+self.brokenSBfileName+'"') 
                    # Renames the centers-of-mass data file.
            print (" -==// Simulation ending \\==-  mcs = ",mcs) #    Prints a warning to the console that 
                                                          # the simulation is terminating early due to detachment.
            self.stopSimulation() #      End this instance of the simulation 
                                            # and continue with the next set of parameters.
#