Notes='''
Parameters for a demonstration of using parameters in a cell sorting model.'''
By='J Sluka'
LastModified='5 Aug 2020'

Notes2='''Note that since this file is part of the CC3D project, any CC3D run output directory will include 
this parameter file.'''

#### Biological Parameters ###############################################
# Var Name              Units                   Comment                                         Reference
model_width_cells = 20  # units cell widths     dimensions of the simulation in cell widths      arbitrary
cell_width_microns= 10  # microns               width of a cell in microns                      PMID:12345678


#### Model Parameters ##################################################
pixels_per_micron = 0.5 # pixels/micron         conversion factor biology <-> model, target= 1  arbitrary
max_mcs= 1000000         # mcs                   maximum number of mcs

#### Parameter Conversions #############################################
model_width_pixels = int(model_width_cells*cell_width_microns*pixels_per_micron)  
                        # pixels                how big the mode window is, both x and y        na
cell_width_pixels = int(cell_width_microns*pixels_per_micron)
                        # pixels                how wide an indvidual cell is                   na
initial_cell_field_radius = int(0.3 * model_width_pixels)
                        # pixels                intial width of the blob of cells               na

# 2D
cell_targetVolume = (cell_width_pixels)**2
cell_targetSurface= 4.*cell_width_pixels

lambda_volume = 3*25/cell_targetVolume
                        # potts energy          lambda_volume for both kinds of cells, the reference lambda is 3, and the 
                        #                       reference volume 25 (2D)
lambda_surface = 2*5/cell_width_pixels
                        # potts energy          lambda_surface for both kinds of cells, the reference lambda is 2, and the 
                        #                       reference surface 5 (2D) (actually just using the cell width)

# adhesion values
j_MM =  0.*5/cell_width_pixels # reference j is 0,  reference width is 5 
j_MC = 16.*5/cell_width_pixels # reference j is 16, reference width is 5
j_MN = 16.*5/cell_width_pixels # reference j is 16, reference width is 5
j_CC =  2.*5/cell_width_pixels # reference j is 2,  reference width is 5
j_CN = 11.*5/cell_width_pixels # reference j is 11, reference width is 5
j_NN = 16.*5/cell_width_pixels # reference j is 16, reference width is 5

