from cc3d.core.PySteppables import *

import parameters as p   ########################################
    
class CC3D_parameters_exampleSteppable(SteppableBasePy):
    def __init__(self,frequency=1):
        SteppableBasePy.__init__(self,frequency)

    def start(self):    
        print("\n\n\t\tp.cell_targetVolume,p.lambda_volume,p.cell_targetSurface,p.lambda_surface:",p.cell_targetVolume,p.lambda_volume,p.cell_targetSurface,p.lambda_surface)
        # iterating over all cells in simulation        
        for cell in self.cell_list:
#             cell.targetVolume = 25
#             cell.lambdaVolume = 3
#             cell.targetSurface = 20
#             cell.lambdaSurface = 2
            cell.targetVolume  = p.cell_targetVolume
            cell.lambdaVolume  = p.lambda_volume
            cell.targetSurface = p.cell_targetSurface
            cell.lambdaSurface = p.lambda_surface
        
        self.plot_win1 = self.add_new_plot_window(title='Hetero Contact Area',
                x_axis_title='MonteCarlo Step (MCS)', x_scale_type='linear', 
                y_axis_title='Hetero Area',           y_scale_type='linear',
                grid=False)
        self.plot_win1.add_plot("HArea", style='Lines', color='red', size=2)

    def step(self,mcs):  
        # Peridodically generate a rough metric of how good the sorting is. 
        # Just find the total heterologous contact area.
        if mcs % 200 == 0:
            total_hetero_area=0
            for cell in self.cell_list:
                cell_surface=cell.surface
                for neighbor, common_surface_area in self.get_cell_neighbor_data_list(cell):
                    if neighbor:  # make sure the neightbor is actually a cell and not medium
                        if cell.type != neighbor.type:
                            total_hetero_area +=  common_surface_area
                        if neighbor:
                            cell_surface -= common_surface_area # to calc the medium contact area
            print("\t\t\tHeterologous Surface Area (excluding medium) =",total_hetero_area)
            # arguments are (name of the data series, x, y)
            self.plot_win1.add_data_point("HArea", mcs, total_hetero_area)            

    