def configure_simulation():
    
    import parameters as p   #####################################
    
    from cc3d.core.XMLUtils import ElementCC3D
    CompuCell3DElmnt=ElementCC3D("CompuCell3D",{"Revision":"20200731","Version":"4.2.3"})
    
    MetadataElmnt=CompuCell3DElmnt.ElementCC3D("Metadata")
    # Basic properties simulation
    MetadataElmnt.ElementCC3D("NumberOfProcessors",{},"4")
    MetadataElmnt.ElementCC3D("DebugOutputFrequency",{},"500")
    # MetadataElmnt.ElementCC3D("NonParallelModule",{"Name":"Potts"})
    
    PottsElmnt=CompuCell3DElmnt.ElementCC3D("Potts")
    # Basic properties of CPM (GGH) algorithm
 #  PottsElmnt.ElementCC3D("Dimensions",{"x":"100","y":"100","z":"1"})
    PottsElmnt.ElementCC3D("Dimensions",{"x":p.model_width_pixels,"y":p.model_width_pixels,"z":"1"})
 #  PottsElmnt.ElementCC3D("Steps",{},10000)
    PottsElmnt.ElementCC3D("Steps",{},p.max_mcs)
    PottsElmnt.ElementCC3D("Temperature",{},"20.0")  # 15
    PottsElmnt.ElementCC3D("NeighborOrder",{},"3")
    
    PluginElmnt=CompuCell3DElmnt.ElementCC3D("Plugin",{"Name":"CellType"})
    # Listing all cell types in the simulation
    PluginElmnt.ElementCC3D("CellType",{"TypeId":"0","TypeName":"Medium"})
    PluginElmnt.ElementCC3D("CellType",{"TypeId":"1","TypeName":"Condensing"})
    PluginElmnt.ElementCC3D("CellType",{"TypeId":"2","TypeName":"Noncondensing"})
    
    CompuCell3DElmnt.ElementCC3D("Plugin",{"Name":"Volume"})
    
    CompuCell3DElmnt.ElementCC3D("Plugin",{"Name":"Surface"})
    
    PluginElmnt_3=CompuCell3DElmnt.ElementCC3D("Plugin",{"Name":"NeighborTracker"})
    
    PluginElmnt_1=CompuCell3DElmnt.ElementCC3D("Plugin",{"Name":"CenterOfMass"})

    PluginElmnt_2=CompuCell3DElmnt.ElementCC3D("Plugin",{"Name":"Contact"})
    # Specification of adhesion energies
#     PluginElmnt_2.ElementCC3D("Energy",{"Type1":"Medium",       "Type2":"Medium"},       " 0.0")
#     PluginElmnt_2.ElementCC3D("Energy",{"Type1":"Medium",       "Type2":"Condensing"},   "16.0")
#     PluginElmnt_2.ElementCC3D("Energy",{"Type1":"Medium",       "Type2":"Noncondensing"},"16.0")
#     PluginElmnt_2.ElementCC3D("Energy",{"Type1":"Condensing",   "Type2":"Condensing"},   " 2.0")
#     PluginElmnt_2.ElementCC3D("Energy",{"Type1":"Condensing",   "Type2":"Noncondensing"},"11.0")
#     PluginElmnt_2.ElementCC3D("Energy",{"Type1":"Noncondensing","Type2":"Noncondensing"},"16.0")
    print("\n\n\t\tj_MM,j_MC,j_MN,j_CC,j_CN,j_NN:",p.j_MM,p.j_MC,p.j_MN,p.j_CC,p.j_CN,p.j_NN)
    PluginElmnt_2.ElementCC3D("Energy",{"Type1":"Medium",       "Type2":"Medium"},       p.j_MM)
    PluginElmnt_2.ElementCC3D("Energy",{"Type1":"Medium",       "Type2":"Condensing"},   p.j_MC)
    PluginElmnt_2.ElementCC3D("Energy",{"Type1":"Medium",       "Type2":"Noncondensing"},p.j_MN)
    PluginElmnt_2.ElementCC3D("Energy",{"Type1":"Condensing",   "Type2":"Condensing"},   p.j_CC)
    PluginElmnt_2.ElementCC3D("Energy",{"Type1":"Condensing",   "Type2":"Noncondensing"},p.j_CN)
    PluginElmnt_2.ElementCC3D("Energy",{"Type1":"Noncondensing","Type2":"Noncondensing"},p.j_NN)
    PluginElmnt_2.ElementCC3D("NeighborOrder",{},"3")  # 3 2
    
    SteppableElmnt=CompuCell3DElmnt.ElementCC3D("Steppable",{"Type":"BlobInitializer"})
    # Initial layout of cells in the form of spherical (circular in 2D) blob
    RegionElmnt=SteppableElmnt.ElementCC3D("Region")
#    RegionElmnt.ElementCC3D("Center",{"x":"50","y":"50","z":"0"})
    RegionElmnt.ElementCC3D("Center",{"x":int(p.model_width_pixels/2),"y":int(p.model_width_pixels/2),"z":"0"})
#    RegionElmnt.ElementCC3D("Radius",{},"20")
    RegionElmnt.ElementCC3D("Radius",{},p.initial_cell_field_radius)
    RegionElmnt.ElementCC3D("Gap",{},"0")
#    RegionElmnt.ElementCC3D("Width",{},"5")
    print("\n\n\tp.cell_width_pixels:",p.cell_width_pixels)
    RegionElmnt.ElementCC3D("Width",{},p.cell_width_pixels)
    RegionElmnt.ElementCC3D("Types",{},"Condensing,Condensing,Condensing,Noncondensing,Noncondensing,Noncondensing,Noncondensing,Noncondensing")

    CompuCellSetup.setSimulationXMLDescription(CompuCell3DElmnt)            

from cc3d import CompuCellSetup
        
configure_simulation()                      

from CC3D_parameters_exampleSteppables import CC3D_parameters_exampleSteppable
CompuCellSetup.register_steppable(steppable=CC3D_parameters_exampleSteppable(frequency=1))

CompuCellSetup.run()
