from cc3d.core.PySteppables import *


class CellGrowth1Steppable(SteppableBasePy):

    def __init__(self, frequency=1):

        SteppableBasePy.__init__(self, frequency)

    def start(self):
        """
        any code in the start function runs before MCS=0
        """
        cell = self.new_cell(self.TUMORPROLIFERATING)
        self.cell_field[100:102, 100:102, 0] = cell

        cell.targetVolume = 25
        cell.lambdaVolume = 5.0

    def step(self, mcs):
        """
        type here the code that will run every frequency MCS
        :param mcs: current Monte Carlo step
        """

        for cell in self.cell_list:

            if cell.type in [self.TUMORPROLIFERATING]:
                cell.targetVolume += 0.2
