from cc3d.core.PySteppables import *


def ir(x):
    return int(round(x))


class AvascularTumorSteppable(SteppableBasePy):

    def start(self):
        cell = self.new_cell(self.TUMORPROLIFERATING)
        self.cell_field[100:102, 100:102, 0] = cell

        cell.targetVolume = 25
        cell.lambdaVolume = 5.0

    def step(self, mcs):
        nutrient_field = self.field.Nutrient

        for cell in self.cell_list:
            x_com = ir(cell.xCOM)
            y_com = ir(cell.yCOM)
            z_com = ir(cell.zCOM)

            nutrient_level = nutrient_field[x_com, y_com, z_com]

            if cell.type in [self.TUMORPROLIFERATING, self.TUMOR]:
                nutrient_based_growth_component = min(0.2, 0.01 * nutrient_level)

                delta = max(0.0, nutrient_based_growth_component - 0.05 * (cell.targetVolume - cell.volume))

                # print('cell type = ', cell.type)
                # print('nutrient_based_growth_component=', nutrient_based_growth_component)
                # print('(cell.targetVolume - cell.volume) = ', cell.targetVolume - cell.volume)
                # print('delta = ', delta)

                cell.targetVolume += delta

        if len(self.cell_list) > 200:
            for cell in self.cell_list:
                x_com = ir(cell.xCOM)
                y_com = ir(cell.yCOM)
                z_com = ir(cell.zCOM)
                nutrient_level = nutrient_field[x_com, y_com, z_com]
                if nutrient_level < 20:
                    cell.type = self.NECROTIC


class MitosisSteppable(MitosisSteppableBase):
    def __init__(self, frequency=1):
        MitosisSteppableBase.__init__(self, frequency)

    def step(self, mcs):

        cells_to_divide = []
        for cell in self.cell_list:
            if cell.volume > 50 and cell.type in [self.TUMORPROLIFERATING, self.TUMOR]:
                cells_to_divide.append(cell)
                # print('mitosis adding cell ', cell.id)

        for cell in cells_to_divide:
            self.divide_cell_random_orientation(cell)

    def update_attributes(self):
        # reducing parent target volume
        self.parent_cell.targetVolume /= 2.0

        self.clone_parent_2_child()

        if self.parent_cell.type == self.TUMORPROLIFERATING:
            self.child_cell.type = self.TUMOR
        else:
            self.child_cell.type = self.TUMORPROLIFERATING
