from cc3d.core.PySteppables import *


class CellGrowth2Steppable(SteppableBasePy):

    def __init__(self, frequency=1):

        SteppableBasePy.__init__(self, frequency)

    def start(self):
        """
        any code in the start function runs before MCS=0
        """
        cell = self.new_cell(self.TUMORPROLIFERATING)
        self.cell_field[100:102, 100:102, 0] = cell

        cell.targetVolume = 25
        cell.lambdaVolume = 5.0

    def step(self, mcs):
        """
        type here the code that will run every frequency MCS
        :param mcs: current Monte Carlo step
        """

        for cell in self.cell_list:

            if cell.type in [self.TUMORPROLIFERATING]:
                cell.targetVolume += 0.2


class MitosisSteppable(MitosisSteppableBase):
    def __init__(self, frequency=1):
        MitosisSteppableBase.__init__(self, frequency)

    def step(self, mcs):

        cells_to_divide = []
        for cell in self.cell_list:
            if cell.volume > 50:
                cells_to_divide.append(cell)

        for cell in cells_to_divide:
            self.divide_cell_random_orientation(cell)

    def update_attributes(self):
        # reducing parent target volume
        self.parent_cell.targetVolume /= 2.0

        self.clone_parent_2_child()

        if self.parent_cell.type == self.TUMORPROLIFERATING:
            self.child_cell.type = self.TUMOR
        else:
            self.child_cell.type = self.TUMORPROLIFERATING
